/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

class GrDeclarationHighlightingVisitor
extends GroovyRecursiveElementVisitor {
    private final List<HighlightInfo> myInfos;

    public GrDeclarationHighlightingVisitor(List<HighlightInfo> collector) {
        this.myInfos = collector;
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/plugins/groovy/annotator/GrDeclarationHighlightingVisitor", "visitReferenceExpression"));
        }
        super.visitReferenceExpression(referenceExpression);
        this.visit(referenceExpression);
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/annotator/GrDeclarationHighlightingVisitor", "visitCodeReferenceElement"));
        }
        super.visitCodeReferenceElement(refElement);
        this.visit(refElement);
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        TextAttributesKey attribute;
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/annotator/GrDeclarationHighlightingVisitor", "visitVariable"));
        }
        super.visitVariable(variable);
        if ((PsiUtil.isLocalVariable(variable) || variable instanceof GrParameter) && (attribute = GrHighlightUtil.getDeclarationHighlightingAttribute(variable, null)) != null) {
            PsiElement nameElement = variable.getNameIdentifierGroovy();
            this.addInfo(attribute, nameElement);
        }
    }

    private void visit(GrReferenceElement element) {
        ProgressManager.checkCanceled();
        PsiElement resolved = element.resolve();
        TextAttributesKey attribute = GrHighlightUtil.getDeclarationHighlightingAttribute(resolved, element);
        if (attribute != null) {
            PsiElement refNameElement = GrHighlightUtil.getElementToHighlight(element);
            this.addInfo(attribute, refNameElement);
        }
    }

    private void addInfo(TextAttributesKey attribute, PsiElement nameElement) {
        assert (this.myInfos != null);
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.INFORMATION).range(nameElement).needsUpdateOnTyping(false).textAttributes(attribute).create();
        if (info != null) {
            this.myInfos.add(info);
        }
    }
}

