/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.assignment;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.assignment.ConstructorCallInfo;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrListOrMapInfo
implements ConstructorCallInfo<GrListOrMap> {
    private final GrListOrMap myListOrMap;
    private final LiteralConstructorReference myReference;

    public GrListOrMapInfo(GrListOrMap listOrMap) {
        this.myListOrMap = listOrMap;
        assert (listOrMap.getReference() instanceof LiteralConstructorReference);
        this.myReference = (LiteralConstructorReference)listOrMap.getReference();
    }

    @Override
    @Nullable
    public GrArgumentList getArgumentList() {
        return null;
    }

    @Override
    @Nullable
    public PsiType[] getArgumentTypes() {
        if (this.myListOrMap.isMap()) {
            GrNamedArgument[] args = this.myListOrMap.getNamedArguments();
            if (args.length == 0) {
                return new PsiType[]{this.myListOrMap.getType()};
            }
            return PsiUtil.getArgumentTypes(args, GrExpression.EMPTY_ARRAY, GrClosableBlock.EMPTY_ARRAY, true, null);
        }
        GrExpression[] args = this.myListOrMap.getInitializers();
        return PsiUtil.getArgumentTypes(GrNamedArgument.EMPTY_ARRAY, args, GrClosableBlock.EMPTY_ARRAY, true, null);
    }

    @Override
    @Nullable
    public GrExpression getInvokedExpression() {
        return null;
    }

    @Override
    @Nullable
    public PsiType getQualifierInstanceType() {
        return null;
    }

    @Override
    @NotNull
    public PsiElement getHighlightElementForCategoryQualifier() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("not applicable");
    }

    @Override
    @NotNull
    public PsiElement getElementToHighlight() {
        GrListOrMap grListOrMap = this.myListOrMap;
        if (grListOrMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "getElementToHighlight"));
        }
        return grListOrMap;
    }

    @Override
    @NotNull
    public GroovyResolveResult advancedResolve() {
        GroovyResolveResult groovyResolveResult = PsiImplUtil.extractUniqueResult(this.multiResolve());
        if (groovyResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "advancedResolve"));
        }
        return groovyResolveResult;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve() {
        GroovyResolveResult[] results = this.myReference.multiResolve(false);
        if (results.length == 1 && results[0].getElement() instanceof PsiClass) {
            if (GroovyResolveResult.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "multiResolve"));
            }
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        if (results == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "multiResolve"));
        }
        return results;
    }

    @Override
    @NotNull
    public GrListOrMap getCall() {
        GrListOrMap grListOrMap = this.myListOrMap;
        if (grListOrMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "getCall"));
        }
        return grListOrMap;
    }

    @Override
    public GroovyResolveResult[] multiResolveClass() {
        PsiClassType type = this.myReference.getConstructedClassType();
        if (type == null) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        GroovyResolveResult result = GroovyResolveResultImpl.from(type.resolveGenerics());
        if (result == GroovyResolveResult.EMPTY_RESULT) {
            return GroovyResolveResult.EMPTY_ARRAY;
        }
        return new GroovyResolveResult[]{result};
    }

    @Override
    @NotNull
    public GrExpression[] getExpressionArguments() {
        GrExpression[] grExpressionArray = this.myListOrMap.isMap() ? GrExpression.EMPTY_ARRAY : this.myListOrMap.getInitializers();
        if (grExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "getExpressionArguments"));
        }
        return grExpressionArray;
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        if (GrClosableBlock.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "getClosureArguments"));
        }
        return GrClosableBlock.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public GrNamedArgument[] getNamedArguments() {
        GrNamedArgument[] grNamedArgumentArray = this.myListOrMap.isMap() ? this.myListOrMap.getNamedArguments() : GrNamedArgument.EMPTY_ARRAY;
        if (grNamedArgumentArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/assignment/GrListOrMapInfo", "getNamedArguments"));
        }
        return grNamedArgumentArray;
    }
}

