/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.ReplacementData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformations;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class ChangeToOperatorInspection
extends BaseInspection {
    public boolean useDoubleNegation = true;
    public boolean shouldChangeCompareToEqualityToEquals = true;

    @Override
    @NotNull
    protected BaseInspectionVisitor buildVisitor() {
        BaseInspectionVisitor baseInspectionVisitor = new BaseInspectionVisitor(){

            @Override
            public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1", "visitMethodCallExpression"));
                }
                GrExpression invokedExpression = methodCallExpression.getInvokedExpression();
                if (!(invokedExpression instanceof GrReferenceExpression)) {
                    return;
                }
                PsiElement element = ((GrReferenceExpression)invokedExpression).getReferenceNameElement();
                if (element == null) {
                    return;
                }
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null || method.hasModifierProperty("static")) {
                    return;
                }
                String methodName = method.getName();
                Transformation transformation = Transformations.TRANSFORMATIONS.get(methodName);
                if (transformation == null) {
                    return;
                }
                OptionsData optionsData = new OptionsData(ChangeToOperatorInspection.this.useDoubleNegation, ChangeToOperatorInspection.this.shouldChangeCompareToEqualityToEquals);
                ReplacementData replacement = transformation.transform(methodCallExpression, optionsData);
                if (replacement == null) {
                    return;
                }
                GroovyFix fix = this.getFix(GroovyInspectionBundle.message("replace.with.operator.fix", methodName), replacement);
                this.registerError(element, GroovyInspectionBundle.message("replace.with.operator.message", methodName), new LocalQuickFix[]{fix}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private GroovyFix getFix(final @NotNull String title, final ReplacementData replacement) {
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1", "getFix"));
                }
                return new GroovyFix(){

                    @NotNull
                    public String getFamilyName() {
                        String string = title;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1$1", "getFamilyName"));
                        }
                        return string;
                    }

                    @Override
                    protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1$1", "doFix"));
                        }
                        if (descriptor2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection$1$1", "doFix"));
                        }
                        PsiElement element = descriptor2.getPsiElement().getParent();
                        if (!(element instanceof GrReferenceExpression)) {
                            return;
                        }
                        PsiElement call = element.getParent();
                        if (!(call instanceof GrMethodCallExpression)) {
                            return;
                        }
                        1.replaceExpression(replacement.getElementToReplace((GrMethodCallExpression)call), replacement.getReplacement());
                    }
                };
            }
        };
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/ChangeToOperatorInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("replace.with.operator.double.negation.option", new Object[0]), "useDoubleNegation");
        optionsPanel.addCheckbox(GroovyInspectionBundle.message("replace.with.operator.compareTo.equality.option", new Object[0]), "shouldChangeCompareToEqualityToEquals");
        return optionsPanel;
    }
}

