/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data;

import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public final class ReplacementData {
    private final String myReplacement;
    private final NotNullFunction<GrMethodCallExpression, GrExpression> myElementToReplace;

    public ReplacementData(@NotNull String replacement, @Nullable NotNullFunction<GrMethodCallExpression, GrExpression> elementToReplace) {
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/ReplacementData", "<init>"));
        }
        this.myReplacement = replacement;
        this.myElementToReplace = elementToReplace;
    }

    @NotNull
    @Contract(pure=true)
    public String getReplacement() {
        String string = this.myReplacement;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/ReplacementData", "getReplacement"));
        }
        return string;
    }

    @NotNull
    public GrExpression getElementToReplace(@NotNull GrMethodCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/ReplacementData", "getElementToReplace"));
        }
        GrExpression grExpression = this.myElementToReplace == null ? call : (GrExpression)this.myElementToReplace.fun((Object)call);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/data/ReplacementData", "getElementToReplace"));
        }
        return grExpression;
    }
}

