/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.UnaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

class AsBooleanTransformation
extends UnaryTransformation {
    public static final String NEGATION = GroovyTokenTypes.mLNOT.toString();
    public static final String DOUBLE_NEGATION = NEGATION + NEGATION;

    AsBooleanTransformation() {
    }

    @Override
    @NotNull
    protected GrExpression getExpandedElement(@NotNull GrMethodCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "getExpandedElement"));
        }
        PsiElement parent = callExpression.getParent();
        if (BoolUtils.isNegation(parent)) {
            GrExpression grExpression = (GrExpression)parent;
            if (grExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "getExpandedElement"));
            }
            return grExpression;
        }
        GrExpression grExpression = super.getExpandedElement(callExpression);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/AsBooleanTransformation", "getExpandedElement"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    protected String getPrefix(MethodCallData methodInfo, OptionsData optionsData) {
        if (methodInfo.isNegated()) {
            return NEGATION;
        }
        if (AsBooleanTransformation.isImplicitlyBoolean(methodInfo)) {
            return "";
        }
        if (optionsData.useDoubleNegation()) {
            return DOUBLE_NEGATION;
        }
        return null;
    }

    private static boolean isImplicitlyBoolean(MethodCallData methodInfo) {
        return methodInfo.getBackingElement().getParent() instanceof GrIfStatement;
    }
}

