/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;

abstract class BinaryTransformation
extends Transformation {
    BinaryTransformation() {
    }

    @Override
    @Nullable
    public String getReplacement(MethodCallData methodInfo, OptionsData optionsData) {
        String lhs = this.getLhs(methodInfo);
        String operator = this.getOperator(methodInfo, optionsData);
        String rhs = this.getRhs(methodInfo);
        if (lhs == null || operator == null || rhs == null) {
            return null;
        }
        return String.format("%s %s %s", lhs, operator, rhs);
    }

    @Nullable
    protected String getLhs(MethodCallData methodInfo) {
        return methodInfo.getBase();
    }

    @Nullable
    protected abstract String getOperator(MethodCallData var1, OptionsData var2);

    @Nullable
    protected String getRhs(MethodCallData methodInfo) {
        String[] arguments = methodInfo.getArguments();
        if (arguments.length != 1) {
            return null;
        }
        return arguments[0];
    }
}

