/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.google.common.base.MoreObjects;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

class CompareToTransformation
extends BinaryTransformation {
    CompareToTransformation() {
    }

    @Override
    @NotNull
    protected GrExpression getExpandedElement(@NotNull GrMethodCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "getExpandedElement"));
        }
        PsiElement parent = callExpression.getParent();
        GrExpression grExpression = ComparisonUtils.isComparison(parent) ? (GrExpression)parent : super.getExpandedElement(callExpression);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/CompareToTransformation", "getExpandedElement"));
        }
        return grExpression;
    }

    @Override
    protected String getOperator(MethodCallData methodInfo, OptionsData optionsData) {
        IElementType comparison = methodInfo.getComparison();
        if (CompareToTransformation.shouldChangeCompareToEqualityToEquals(optionsData, comparison)) {
            return ((IElementType)MoreObjects.firstNonNull((Object)comparison, (Object)GroovyTokenTypes.mCOMPARE_TO)).toString();
        }
        return null;
    }

    private static boolean shouldChangeCompareToEqualityToEquals(OptionsData optionsData, IElementType comparison) {
        return !CompareToTransformation.isEquality(comparison) || optionsData.shouldChangeCompareToEqualityToEquals();
    }

    private static boolean isEquality(IElementType comparison) {
        return comparison == GroovyTokenTypes.mNOT_EQUAL || comparison == GroovyTokenTypes.mEQUAL;
    }
}

