/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.BinaryTransformation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.BoolUtils;

class EqualsTransformation
extends BinaryTransformation {
    EqualsTransformation() {
    }

    @Override
    @NotNull
    protected GrExpression getExpandedElement(@NotNull GrMethodCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/EqualsTransformation", "getExpandedElement"));
        }
        PsiElement parent = callExpression.getParent();
        GrExpression grExpression = BoolUtils.isNegation(parent) ? (GrExpression)parent : super.getExpandedElement(callExpression);
        if (grExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/EqualsTransformation", "getExpandedElement"));
        }
        return grExpression;
    }

    @Override
    @Nullable
    protected String getOperator(MethodCallData methodInfo, OptionsData optionsData) {
        return methodInfo.isNegated() ? "!=" : "==";
    }
}

