/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.util.NotNullFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.ReplacementData;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public abstract class Transformation {
    @Nullable
    public ReplacementData transform(GrMethodCallExpression callExpression, OptionsData optionsData) {
        GrExpression element = this.getExpandedElement(callExpression);
        MethodCallData methodInfo = MethodCallData.create(element);
        if (methodInfo == null) {
            return null;
        }
        String replacement = this.getReplacement(methodInfo, optionsData);
        if (replacement == null) {
            return null;
        }
        return new ReplacementData(replacement, (NotNullFunction<GrMethodCallExpression, GrExpression>)((NotNullFunction)this::getExpandedElement));
    }

    @NotNull
    protected GrExpression getExpandedElement(@NotNull GrMethodCallExpression callExpression) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "getExpandedElement"));
        }
        GrMethodCallExpression grMethodCallExpression = callExpression;
        if (grMethodCallExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/Transformation", "getExpandedElement"));
        }
        return grMethodCallExpression;
    }

    @Nullable
    public abstract String getReplacement(MethodCallData var1, OptionsData var2);
}

