/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;

public class UnaryTransformation
extends Transformation {
    @NotNull
    private final String myOperator;

    public UnaryTransformation(@NotNull IElementType operatorType) {
        if (operatorType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operatorType", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/UnaryTransformation", "<init>"));
        }
        this(operatorType.toString());
    }

    public UnaryTransformation(@NotNull String operator) {
        if (operator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operator", "org/jetbrains/plugins/groovy/codeInspection/changeToOperator/transformations/UnaryTransformation", "<init>"));
        }
        this.myOperator = operator;
    }

    public UnaryTransformation() {
        this("");
    }

    @Override
    @Nullable
    public String getReplacement(MethodCallData call, OptionsData options) {
        String[] arguments = call.getArguments();
        if (arguments.length != 0) {
            return null;
        }
        String prefix = this.getPrefix(call, options);
        String base = call.getBase();
        if (prefix == null) {
            return null;
        }
        return prefix + base;
    }

    @Nullable
    protected String getPrefix(MethodCallData call, OptionsData optionsData) {
        return this.myOperator;
    }
}

