/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.path;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.GrMethodCallImpl;

public class GrMethodCallExpressionImpl
extends GrMethodCallImpl
implements GrMethodCallExpression,
GrCallExpression {
    public GrMethodCallExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl", "<init>"));
        }
        super(node);
    }

    public String toString() {
        return "Method call";
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitMethodCallExpression(this);
    }

    @Override
    public GrExpression replaceClosureArgument(@NotNull GrClosableBlock closure, @NotNull GrExpression newExpr) throws IncorrectOperationException {
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl", "replaceClosureArgument"));
        }
        if (newExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpr", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl", "replaceClosureArgument"));
        }
        if (newExpr instanceof GrClosableBlock) {
            return closure.replaceWithExpression(newExpr, true);
        }
        Object[] closureArguments = this.getClosureArguments();
        int i = ArrayUtil.find((Object[])closureArguments, (Object)closure);
        GrArgumentList argList = this.getArgumentList();
        if (argList.getText().isEmpty()) {
            argList = (GrArgumentList)argList.replace(GroovyPsiElementFactory.getInstance(this.getProject()).createArgumentList());
        }
        for (int j = 0; j < i; ++j) {
            argList.add((PsiElement)closureArguments[j]);
            closureArguments[j].delete();
        }
        GrExpression result = (GrExpression)argList.add(newExpr);
        closure.delete();
        return result;
    }

    @Override
    @NotNull
    public GrClosableBlock[] getClosureArguments() {
        List children = this.findChildrenByType((IElementType)GroovyElementTypes.CLOSABLE_BLOCK);
        GrClosableBlock[] grClosableBlockArray = children.toArray(new GrClosableBlock[children.size()]);
        if (grClosableBlockArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/path/GrMethodCallExpressionImpl", "getClosureArguments"));
        }
        return grClosableBlockArray;
    }
}

