/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstantList;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.GrTypeDefinitionImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrTypeDefinitionStub;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GrEnumTypeDefinitionImpl
extends GrTypeDefinitionImpl
implements GrEnumTypeDefinition {
    public GrEnumTypeDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "<init>"));
        }
        super(node);
    }

    public GrEnumTypeDefinitionImpl(GrTypeDefinitionStub stub) {
        super(stub, GroovyElementTypes.ENUM_DEFINITION);
    }

    public String toString() {
        return "Enumeration definition";
    }

    @Override
    public GrEnumDefinitionBody getBody() {
        return (GrEnumDefinitionBody)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.ENUM_BODY);
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        PsiClassType[] psiClassTypeArray = new PsiClassType[]{this.createEnumType(), this.createGroovyObjectSupportType()};
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    private PsiClassType createEnumType() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass enumClass = facade.findClass("java.lang.Enum", this.getResolveScope());
        PsiElementFactory factory = facade.getElementFactory();
        if (enumClass != null) {
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            PsiTypeParameter[] typeParameters = enumClass.getTypeParameters();
            if (typeParameters.length == 1) {
                substitutor = substitutor.put(typeParameters[0], (PsiType)factory.createType((PsiClass)this));
            }
            return factory.createType(enumClass, substitutor);
        }
        return TypesUtil.createTypeByFQClassName("java.lang.Enum", this);
    }

    private PsiClassType createGroovyObjectSupportType() {
        return TypesUtil.createTypeByFQClassName("groovy.lang.GroovyObjectSupport", this);
    }

    @Override
    @NotNull
    public GrField[] getFields() {
        Object[] bodyFields = super.getFields();
        Object[] enumConstants = this.getEnumConstants();
        if (bodyFields.length == 0) {
            if (enumConstants == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "getFields"));
            }
            return enumConstants;
        }
        if (enumConstants.length == 0) {
            if (bodyFields == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "getFields"));
            }
            return bodyFields;
        }
        GrField[] grFieldArray = (GrField[])ArrayUtil.mergeArrays((Object[])bodyFields, (Object[])enumConstants);
        if (grFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "getFields"));
        }
        return grFieldArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrEnumTypeDefinitionImpl", "processDeclarations"));
        }
        if (ResolveUtil.shouldProcessMethods((ElementClassHint)processor.getHint(ElementClassHint.KEY))) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint == null ? null : nameHint.getName(state);
            for (PsiMethod method : this.getDefEnumMethods()) {
                if (name != null && !name.equals(method.getName()) || processor.execute((PsiElement)method, state)) continue;
                return false;
            }
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    private PsiMethod[] getDefEnumMethods() {
        return (PsiMethod[])CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            PsiMethod[] defMethods = new PsiMethod[4];
            PsiManagerEx manager = this.getManager();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
            defMethods[0] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "values").setMethodReturnType(factory.createTypeFromText("java.util.Collection<" + this.getName() + ">", (PsiElement)this)).setContainingClass((PsiClass)this).addModifier("public").addModifier("static");
            defMethods[1] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "next").setMethodReturnType((PsiType)factory.createType((PsiClass)this)).setContainingClass((PsiClass)this).addModifier("public");
            defMethods[2] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "previous").setMethodReturnType((PsiType)factory.createType((PsiClass)this)).setContainingClass((PsiClass)this).addModifier("public");
            defMethods[3] = new LightMethodBuilder((PsiManager)manager, (Language)GroovyLanguage.INSTANCE, "valueOf").setMethodReturnType((PsiType)factory.createType((PsiClass)this)).setContainingClass((PsiClass)this).addParameter("name", "java.lang.String").addModifier("public").addModifier("static");
            return CachedValueProvider.Result.create((Object)defMethods, (Object[])new Object[]{this});
        });
    }

    @Override
    public GrEnumConstant[] getEnumConstants() {
        GrEnumConstantList list = this.getEnumConstantList();
        if (list != null) {
            return list.getEnumConstants();
        }
        return GrEnumConstant.EMPTY_ARRAY;
    }

    @Override
    public GrEnumConstantList getEnumConstantList() {
        GrEnumDefinitionBody enumDefinitionBody = this.getBody();
        if (enumDefinitionBody != null) {
            return enumDefinitionBody.getEnumConstantList();
        }
        return null;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitEnumDefinition(this);
    }
}

