/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyResolveResultImpl;

public class GrLightClassReferenceElement
extends LightElement
implements GrCodeReferenceElement {
    @NotNull
    private final String myClassName;
    private final String myText;
    private final PsiElement myContext;

    public GrLightClassReferenceElement(@NotNull String className, @NotNull String text, PsiElement context) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "<init>"));
        }
        super(context.getManager(), (Language)GroovyLanguage.INSTANCE);
        this.myClassName = className;
        this.myText = text;
        this.myContext = context;
    }

    public GrLightClassReferenceElement(PsiClass aClass, PsiElement context) {
        this(aClass.getQualifiedName() != null ? aClass.getQualifiedName() : aClass.getName(), aClass.getName(), context);
    }

    @Override
    public String getReferenceName() {
        return this.myClassName;
    }

    @Override
    @NotNull
    public GroovyResolveResult[] multiResolve(boolean incompleteCode) {
        GroovyResolveResult[] groovyResolveResultArray;
        PsiClass clazz = GroovyPsiManager.getInstance(this.getProject()).findClassWithCache(this.myClassName, this.myContext.getResolveScope());
        if (clazz == null) {
            groovyResolveResultArray = GroovyResolveResult.EMPTY_ARRAY;
        } else {
            GroovyResolveResult[] groovyResolveResultArray2 = new GroovyResolveResult[1];
            groovyResolveResultArray = groovyResolveResultArray2;
            groovyResolveResultArray2[0] = new GroovyResolveResultImpl((PsiElement)clazz, true);
        }
        if (groovyResolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "multiResolve"));
        }
        return groovyResolveResultArray;
    }

    @Override
    @NotNull
    public PsiType[] getTypeArguments() {
        if (PsiType.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "getTypeArguments"));
        }
        return PsiType.EMPTY_ARRAY;
    }

    @Override
    public GrTypeArgumentList getTypeArgumentList() {
        return null;
    }

    @Override
    @NotNull
    public String getClassNameText() {
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "getClassNameText"));
        }
        return string;
    }

    @Override
    public GrCodeReferenceElement getQualifier() {
        return null;
    }

    @Override
    public void setQualifier(@Nullable GrCodeReferenceElement grCodeReferenceElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement getReferenceNameElement() {
        return null;
    }

    @Override
    public boolean isQualified() {
        return false;
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
    }

    public String toString() {
        return "light reference element";
    }

    public PsiElement getElement() {
        return this;
    }

    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @NotNull
    public String getCanonicalText() {
        PsiElement resolved = this.resolve();
        if (resolved instanceof PsiClass) {
            String string = ((PsiClass)resolved).getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "getCanonicalText"));
            }
            return string;
        }
        String string = this.myClassName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "bindToElement"));
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.myManager.areElementsEquivalent(element, this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightClassReferenceElement", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    public String getText() {
        return this.myText;
    }
}

