/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.synthetic;

import com.intellij.lang.Language;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightParameter;

public class GrLightParameterListBuilder
extends LightElement
implements GrParameterList {
    private final List<GrParameter> myParameters = new ArrayList<GrParameter>();
    private GrParameter[] myCachedParameters;

    public GrLightParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    public GrParameter addParameter(@NotNull GrParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightParameterListBuilder", "addParameter"));
        }
        this.myParameters.add(parameter);
        this.myCachedParameters = null;
        return parameter;
    }

    public String toString() {
        return "GrLightParameterListBuilder";
    }

    @Override
    @NotNull
    public GrParameter[] getParameters() {
        if (this.myCachedParameters == null) {
            this.myCachedParameters = this.myParameters.isEmpty() ? GrParameter.EMPTY_ARRAY : this.myParameters.toArray(new GrParameter[this.myParameters.size()]);
        }
        if (this.myCachedParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightParameterListBuilder", "getParameters"));
        }
        return this.myCachedParameters;
    }

    public void copyParameters(@NotNull PsiMethod method, PsiSubstitutor substitutor, PsiMethod scope) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightParameterListBuilder", "copyParameters"));
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            GrLightParameter p = new GrLightParameter(StringUtil.notNullize((String)parameter.getName()), substitutor.substitute(parameter.getType()), (PsiElement)scope);
            if (parameter instanceof GrParameter) {
                p.setOptional(((GrParameter)parameter).isOptional());
            }
            this.addParameter(p);
        }
    }

    @Override
    public int getParameterNumber(GrParameter parameter) {
        return this.getParameterIndex(parameter);
    }

    public int getParameterIndex(PsiParameter parameter) {
        return this.myParameters.indexOf(parameter);
    }

    public int getParametersCount() {
        return this.myParameters.size();
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightParameterListBuilder", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitParameterList((PsiParameterList)this);
        }
    }

    @Override
    public void accept(GroovyElementVisitor visitor2) {
        visitor2.visitParameterList(this);
    }

    @Override
    public void acceptChildren(GroovyElementVisitor visitor2) {
    }

    @NotNull
    public GrParameter removeParameter(int index) {
        GrParameter removed = this.myParameters.remove(index);
        this.myCachedParameters = null;
        GrParameter grParameter = removed;
        if (grParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/synthetic/GrLightParameterListBuilder", "removeParameter"));
        }
        return grParameter;
    }

    public void clear() {
        this.myParameters.clear();
        this.myCachedParameters = null;
    }
}

