/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.dsl.GdslMembersHolderConsumer;
import org.jetbrains.plugins.groovy.dsl.GroovyClassDescriptor;
import org.jetbrains.plugins.groovy.dsl.dsltop.GdslMembersProvider;
import org.jetbrains.plugins.groovy.dsl.holders.CustomMembersHolder;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.GroovyResolverProcessor;

public class GdkMethodDslProvider
implements GdslMembersProvider {
    public void category(String className, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, false);
    }

    public void category(String className, boolean isStatic, GdslMembersHolderConsumer consumer) {
        GdkMethodDslProvider.processCategoryMethods(className, consumer, isStatic);
    }

    private static void processCategoryMethods(String className, GdslMembersHolderConsumer consumer, final boolean isStatic) {
        final GlobalSearchScope scope = consumer.getResolveScope();
        final PsiClass categoryClass = GroovyPsiManager.getInstance(consumer.getProject()).findClassWithCache(className, scope);
        if (categoryClass == null) {
            return;
        }
        VolatileNotNullLazyValue<GdkMethodHolder> methodsMap = new VolatileNotNullLazyValue<GdkMethodHolder>(){

            @NotNull
            protected GdkMethodHolder compute() {
                GdkMethodHolder gdkMethodHolder = GdkMethodHolder.getHolderForClass(categoryClass, isStatic, scope);
                if (gdkMethodHolder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GdkMethodDslProvider$1", "compute"));
                }
                return gdkMethodHolder;
            }
        };
        consumer.addMemberHolder(new CustomMembersHolder((VolatileNotNullLazyValue)methodsMap){
            final /* synthetic */ VolatileNotNullLazyValue val$methodsMap;
            {
                this.val$methodsMap = volatileNotNullLazyValue;
            }

            @Override
            public boolean processMembers(GroovyClassDescriptor descriptor2, PsiScopeProcessor _processor, ResolveState state) {
                for (PsiScopeProcessor each : GroovyResolverProcessor.allProcessors(_processor)) {
                    if (!ResolveUtil.shouldProcessMethods((ElementClassHint)each.getHint(ElementClassHint.KEY)) || ((GdkMethodHolder)this.val$methodsMap.getValue()).processMethods(each, state, descriptor2.getPsiType(), descriptor2.getProject())) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

