/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.SpreadState;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTraitType;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.ClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ClosureMissingMethodContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtilKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.ClassHint;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0017\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/GrReferenceResolveRunner;", "", "place", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "(Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;Lcom/intellij/psi/scope/PsiScopeProcessor;)V", "getPlace", "()Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrReferenceExpression;", "getProcessor", "()Lcom/intellij/psi/scope/PsiScopeProcessor;", "doProcessQualifierType", "", "qualifierType", "Lcom/intellij/psi/PsiType;", "state", "Lcom/intellij/psi/ResolveState;", "processJavaLangClass", "qualifier", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "initialState", "processQualifier", "processQualifierType", "resolveReferenceExpression", "groovy-psi"})
public final class GrReferenceResolveRunner {
    @NotNull
    private final GrReferenceExpression place;
    @NotNull
    private final PsiScopeProcessor processor;

    public final boolean resolveReferenceExpression() {
        boolean processNonCode = !(PsiTreeUtil.skipParentsOfType((PsiElement)this.place, (Class[])new Class[]{GrReferenceExpression.class}) instanceof GrAnnotationNameValuePair);
        ResolveState initialState = ResolveUtilKt.initialState(processNonCode);
        GrExpression qualifier = (GrExpression)this.place.getQualifier();
        if (qualifier == null) {
            PsiElement psiElement = this.place;
            ResolveState resolveState = initialState;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"initialState");
            if (!ResolveUtilKt.treeWalkUp(psiElement, this.processor, resolveState)) {
                return false;
            }
            if (!processNonCode) {
                return true;
            }
            if (this.place.getContext() instanceof GrMethodCall && !ClosureMissingMethodContributor.processMethodsFromClosures(this.place, this.processor)) {
                return false;
            }
        } else if (this.place.getDotTokenType() == GroovyTokenTypes.mSPREAD_DOT) {
            PsiType qType = qualifier.getType();
            PsiType componentType = ClosureParameterEnhancer.findTypeForIteration(qType, (PsiElement)this.place);
            if (componentType != null) {
                ResolveState state;
                ResolveState resolveState = state = initialState.put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier).put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qType, null));
                Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
                return this.processQualifierType(componentType, resolveState);
            }
        } else {
            if (ResolveUtil.isClassReference(this.place)) {
                return false;
            }
            ResolveState resolveState = initialState;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"initialState");
            if (!this.processJavaLangClass(qualifier, resolveState)) {
                return false;
            }
            ResolveState resolveState2 = initialState;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState2, (String)"initialState");
            if (!this.processQualifier(qualifier, resolveState2)) {
                return false;
            }
        }
        return true;
    }

    private final boolean processJavaLangClass(GrExpression qualifier, ResolveState initialState) {
        boolean bl;
        PsiType classType;
        if (!(qualifier instanceof GrReferenceExpression)) {
            return true;
        }
        if (Intrinsics.areEqual((Object)"class", (Object)((GrReferenceExpression)qualifier).getReferenceName()) ^ true && !PsiUtil.isThisReference(qualifier) && !(((GrReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
            return true;
        }
        PsiType psiType = classType = ResolveUtil.unwrapClassType(qualifier.getType());
        if (psiType != null) {
            ResolveState state;
            PsiType psiType2 = psiType;
            PsiType it = psiType2;
            ResolveState resolveState = state = initialState.put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
            bl = this.processQualifierType(classType, resolveState);
        } else {
            bl = true;
        }
        return bl;
    }

    private final boolean processQualifier(GrExpression qualifier, ResolveState initialState) {
        PsiType qualifierType = qualifier.getType();
        ResolveState state = initialState.put(ClassHint.RESOLVE_CONTEXT, (Object)qualifier);
        if (qualifierType == null || Intrinsics.areEqual((Object)PsiType.VOID, (Object)qualifierType)) {
            if (qualifier instanceof GrReferenceExpression) {
                PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
                if (resolved instanceof PsiClass) {
                    PsiClass psiClass = (PsiClass)resolved;
                    if (psiClass == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!ResolveUtil.processClassDeclarations(psiClass, this.processor, state, null, this.place)) {
                        return false;
                    }
                } else if (resolved != null && !resolved.processDeclarations(this.processor, state, (PsiElement)null, (PsiElement)this.place)) {
                    return false;
                }
                if (!(resolved instanceof PsiPackage)) {
                    PsiClassType objectQualifier = TypesUtil.getJavaLangObject(this.place);
                    PsiType psiType = (PsiType)objectQualifier;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"objectQualifier");
                    ResolveState resolveState = state;
                    Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
                    if (!this.processQualifierType(psiType, resolveState)) {
                        return false;
                    }
                }
            }
        } else {
            ResolveState resolveState = state;
            Intrinsics.checkExpressionValueIsNotNull((Object)resolveState, (String)"state");
            if (!this.processQualifierType(qualifierType, resolveState)) {
                return false;
            }
        }
        return true;
    }

    private final boolean processQualifierType(PsiType qualifierType, ResolveState state) {
        PsiDisjunctionType type;
        PsiDisjunctionType psiDisjunctionType;
        PsiType psiType = qualifierType;
        if (!(psiType instanceof PsiDisjunctionType)) {
            psiType = null;
        }
        if ((psiDisjunctionType = (PsiDisjunctionType)psiType) == null || (psiDisjunctionType = psiDisjunctionType.getLeastUpperBound()) == null) {
            psiDisjunctionType = qualifierType;
        }
        PsiDisjunctionType psiDisjunctionType2 = type = psiDisjunctionType;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiDisjunctionType2, (String)"type");
        return this.doProcessQualifierType((PsiType)psiDisjunctionType2, state);
    }

    private final boolean doProcessQualifierType(PsiType qualifierType, ResolveState state) {
        GrTypeDefinition it;
        GrTypeDefinition grTypeDefinition;
        ResolveState resolveState;
        Object[] wildcard;
        if (qualifierType instanceof PsiIntersectionType) {
            Object object;
            block18: {
                Object[] objectArray = ((PsiIntersectionType)qualifierType).getConjuncts();
                Object[] objectArray2 = objectArray;
                for (int i = 0; i < objectArray2.length; ++i) {
                    PsiType it2;
                    Object object2 = objectArray2[i];
                    PsiType psiType = it2 = (PsiType)object2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"it");
                    if (!(!this.processQualifierType(psiType, state))) continue;
                    object = object2;
                    break block18;
                }
                object = null;
            }
            return object == null;
        }
        if (qualifierType instanceof PsiCapturedWildcardType && (wildcard = ((PsiCapturedWildcardType)qualifierType).getWildcard()).isExtends()) {
            PsiType psiType = wildcard.getExtendsBound();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"wildcard.extendsBound");
            return this.processQualifierType(psiType, state);
        }
        if (qualifierType instanceof GrTraitType) {
            Object object;
            block19: {
                wildcard = ((GrTraitType)qualifierType).getConjuncts();
                Object[] objectArray = wildcard;
                Iterator iterator = CollectionsKt.reversed((Iterable)((Iterable)ArraysKt.getIndices((Object[])objectArray))).iterator();
                while (iterator.hasNext()) {
                    PsiType it3;
                    int n = ((Number)iterator.next()).intValue();
                    Object it2 = objectArray[n];
                    PsiType psiType = it3 = (PsiType)it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiType, (String)"it");
                    if (!(!this.processQualifierType(psiType, state))) continue;
                    object = it2;
                    break block19;
                }
                object = null;
            }
            return object == null;
        }
        if (qualifierType instanceof PsiClassType) {
            PsiClassType.ClassResolveResult qualifierResult = ((PsiClassType)qualifierType).resolveGenerics();
            PsiClass psiClass = qualifierResult.getElement();
            if (psiClass != null) {
                PsiClass psiClass2 = psiClass;
                PsiClass it4 = psiClass2;
                resolveState = state.put(PsiSubstitutor.KEY, (Object)qualifierResult.getSubstitutor());
                if (!ResolveUtil.processClassDeclarations(it4, this.processor, resolveState, null, this.place)) {
                    return false;
                }
            }
        } else if (qualifierType instanceof PsiArrayType) {
            GrTypeDefinition grTypeDefinition2 = GroovyPsiManager.getInstance(this.place.getProject()).getArrayClass(((PsiArrayType)qualifierType).getComponentType());
            if (grTypeDefinition2 != null) {
                grTypeDefinition = grTypeDefinition2;
                it = grTypeDefinition;
                if (!ResolveUtil.processClassDeclarations(it, this.processor, state, null, this.place)) {
                    return false;
                }
            }
        }
        if (!(this.place.getParent() instanceof GrMethodCall) && InheritanceUtil.isInheritor((PsiType)qualifierType, (String)"java.util.Collection")) {
            PsiType psiType = ClosureParameterEnhancer.findTypeForIteration(qualifierType, (PsiElement)this.place);
            if (psiType != null) {
                grTypeDefinition = psiType;
                it = (PsiType)grTypeDefinition;
                SpreadState spreadState = (SpreadState)state.get(SpreadState.SPREAD_STATE);
                resolveState = state.put(SpreadState.SPREAD_STATE, (Object)SpreadState.create(qualifierType, spreadState));
                GrTypeDefinition grTypeDefinition3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)grTypeDefinition3, (String)"it");
                ResolveState resolveState2 = resolveState;
                Intrinsics.checkExpressionValueIsNotNull((Object)resolveState2, (String)"resolveState");
                if (!this.processQualifierType((PsiType)grTypeDefinition3, resolveState2)) {
                    return false;
                }
            }
        }
        if (ResolveUtilKt.processNonCodeMembers(state)) {
            if (!ResolveUtil.processCategoryMembers(this.place, this.processor, state)) {
                return false;
            }
            if (!ResolveUtil.processNonCodeMembers(qualifierType, this.processor, this.place, state)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final GrReferenceExpression getPlace() {
        return this.place;
    }

    @NotNull
    public final PsiScopeProcessor getProcessor() {
        return this.processor;
    }

    public GrReferenceResolveRunner(@NotNull GrReferenceExpression place, @NotNull PsiScopeProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        this.place = place;
        this.processor = processor;
    }
}

