/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors;

import com.intellij.openapi.util.Key;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GrScopeProcessorWithHints
implements PsiScopeProcessor,
NameHint,
ElementClassHint {
    @Nullable
    protected final Set<ElementClassHint.DeclarationKind> myResolveTargetKinds;
    @Nullable
    protected final String myName;

    public GrScopeProcessorWithHints(@Nullable String name, @Nullable Set<ElementClassHint.DeclarationKind> resolveTargets) {
        this.myName = name;
        this.myResolveTargetKinds = resolveTargets;
    }

    public <T> T getHint(@NotNull Key<T> hintKey) {
        if (hintKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "org/jetbrains/plugins/groovy/lang/resolve/processors/GrScopeProcessorWithHints", "getHint"));
        }
        if (NameHint.KEY == hintKey && this.myName != null) {
            return (T)this;
        }
        if (ElementClassHint.KEY == hintKey && this.myResolveTargetKinds != null) {
            return (T)this;
        }
        return null;
    }

    public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
        assert (this.myResolveTargetKinds != null) : "don't invoke shouldProcess if resolveTargets are not declared";
        return this.myResolveTargetKinds.contains(kind);
    }

    @NotNull
    public String getName(@NotNull ResolveState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/resolve/processors/GrScopeProcessorWithHints", "getName"));
        }
        assert (this.myName != null) : "don't invoke getName if myName is not declared";
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/processors/GrScopeProcessorWithHints", "getName"));
        }
        return string;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, @Nullable Object associated) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/groovy/lang/resolve/processors/GrScopeProcessorWithHints", "handleEvent"));
        }
    }
}

