/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.changeSignature;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;

public class GrUnresolvableLocalCollisionDetector {
    private GrUnresolvableLocalCollisionDetector() {
    }

    public static void visitLocalsCollisions(PsiElement element, String newName, GroovyPsiElement place, CollidingVariableVisitor visitor2) {
        GrUnresolvableLocalCollisionDetector.visitDownstreamCollisions(newName, place, visitor2);
        GrUnresolvableLocalCollisionDetector.visitUpstreamCollisions(element, newName, place, visitor2);
    }

    private static void visitUpstreamCollisions(PsiElement element, String newName, GroovyPsiElement place, CollidingVariableVisitor visitor2) {
        GroovyResolveResult[] results;
        GrReferenceExpression refExpr = GroovyPsiElementFactory.getInstance(place.getProject()).createReferenceExpressionFromText(newName, place);
        for (GroovyResolveResult result : results = refExpr.multiResolve(false)) {
            PsiElement resolved = result.getElement();
            if (!(resolved instanceof GrParameter) && (!(resolved instanceof GrVariable) || resolved instanceof GrField)) continue;
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)resolved, (PsiElement)element);
            if (parent != null) {
                for (PsiElement current = element; current != null && current != parent; current = current.getParent()) {
                    if (!(current instanceof PsiMethod) && !(current instanceof PsiClass) && !(current instanceof GrClosableBlock)) continue;
                    return;
                }
            }
            if (place.getManager().areElementsEquivalent(element, resolved)) continue;
            visitor2.visitCollidingVariable((PsiVariable)resolved);
        }
    }

    private static void visitDownstreamCollisions(final String newName, GroovyPsiElement place, final CollidingVariableVisitor visitor2) {
        place.accept(new GroovyRecursiveElementVisitor(){

            @Override
            public void visitVariableDeclaration(@NotNull GrVariableDeclaration variableDeclaration) {
                GrVariable[] variables;
                if (variableDeclaration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableDeclaration", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrUnresolvableLocalCollisionDetector$1", "visitVariableDeclaration"));
                }
                for (GrVariable variable : variables = variableDeclaration.getVariables()) {
                    if (!variable.getName().equals(newName)) continue;
                    visitor2.visitCollidingVariable(variable);
                }
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrUnresolvableLocalCollisionDetector$1", "visitMethod"));
                }
            }

            @Override
            public void visitClosure(@NotNull GrClosableBlock closure) {
                if (closure == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrUnresolvableLocalCollisionDetector$1", "visitClosure"));
                }
            }

            @Override
            public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
                if (typeDefinition == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/refactoring/changeSignature/GrUnresolvableLocalCollisionDetector$1", "visitTypeDefinition"));
                }
            }
        });
    }

    static interface CollidingVariableVisitor {
        public void visitCollidingVariable(PsiVariable var1);
    }
}

