/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.parameter;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;

class ReferencedElementsCollector
extends GroovyRecursiveElementVisitor {
    private final List<PsiElement> myResult = new ArrayList<PsiElement>();

    ReferencedElementsCollector() {
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/ReferencedElementsCollector", "visitReferenceExpression"));
        }
        this.add(referenceExpression);
    }

    private void add(GrReferenceElement referenceExpression) {
        PsiElement resolved = referenceExpression.resolve();
        if (resolved != null) {
            this.myResult.add(resolved);
        }
    }

    @Override
    public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/refactoring/introduce/parameter/ReferencedElementsCollector", "visitCodeReferenceElement"));
        }
        this.add(refElement);
    }

    public List<PsiElement> getResult() {
        return this.myResult;
    }
}

