/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.runner;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaCommandLineState;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.configurations.SimpleProgramParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyRunnerPsiUtil;
import org.jetbrains.plugins.groovy.runner.DefaultGroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyRunConfigurationEditor;
import org.jetbrains.plugins.groovy.runner.GroovyScriptRunner;
import org.jetbrains.plugins.groovy.runner.GroovyScriptUtil;
import org.jetbrains.plugins.groovy.runner.util.CommonProgramRunConfigurationParametersDelegate;

public class GroovyScriptRunConfiguration
extends ModuleBasedConfiguration<RunConfigurationModule>
implements CommonJavaRunConfigurationParameters,
RefactoringListenerProvider {
    private String vmParams;
    private String workDir;
    private boolean isDebugEnabled;
    private boolean isAddClasspathToTheRunner;
    @Nullable
    private String scriptParams;
    @Nullable
    private String scriptPath;
    private final Map<String, String> envs = new LinkedHashMap();
    public boolean passParentEnv = true;
    private boolean myAlternativeJrePathEnabled;
    @Nullable
    private String myAlternativeJrePath;

    public GroovyScriptRunConfiguration(String name, Project project, ConfigurationFactory factory) {
        super(name, new RunConfigurationModule(project), factory);
        this.workDir = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
    }

    @Nullable
    public Module getModule() {
        return (Module)ObjectUtils.chooseNotNull((Object)this.getConfigurationModule().getModule(), (Object)ContainerUtil.getFirstItem(this.getValidModules()));
    }

    public Collection<Module> getValidModules() {
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        GroovyScriptRunner scriptRunner = this.getScriptRunner();
        if (scriptRunner == null) {
            return Arrays.asList(modules);
        }
        ArrayList<Module> res = new ArrayList<Module>();
        for (Module module : modules) {
            if (!scriptRunner.isValidModule(module)) continue;
            res.add(module);
        }
        return res;
    }

    @Nullable
    private GroovyScriptRunner getScriptRunner() {
        VirtualFile scriptFile = ScriptFileUtil.findScriptFileByPath((String)this.getScriptPath());
        if (scriptFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(scriptFile);
        if (!(psiFile instanceof GroovyFile)) {
            return null;
        }
        GroovyFile groovyFile = (GroovyFile)psiFile;
        if (groovyFile.isScript()) {
            return GroovyScriptUtil.getScriptType(groovyFile).getRunner();
        }
        return new DefaultGroovyScriptRunner();
    }

    public void readExternal(Element element) {
        super.readExternal(element);
        this.readModule(element);
        this.scriptPath = ExternalizablePath.localPathValue((String)JDOMExternalizer.readString((Element)element, (String)"path"));
        this.vmParams = JDOMExternalizer.readString((Element)element, (String)"vmparams");
        this.scriptParams = JDOMExternalizer.readString((Element)element, (String)"params");
        String wrk = JDOMExternalizer.readString((Element)element, (String)"workDir");
        if (!".".equals(wrk)) {
            this.workDir = ExternalizablePath.localPathValue((String)wrk);
        }
        this.isDebugEnabled = Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)"debug"));
        this.isAddClasspathToTheRunner = Boolean.parseBoolean(JDOMExternalizer.readString((Element)element, (String)"addClasspath"));
        this.envs.clear();
        JDOMExternalizer.readMap((Element)element, this.envs, null, (String)"env");
        this.myAlternativeJrePathEnabled = JDOMExternalizer.readBoolean((Element)element, (String)"alternativeJrePathEnabled");
        this.myAlternativeJrePath = JDOMExternalizer.readString((Element)element, (String)"alternativeJrePath");
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        this.writeModule(element);
        JDOMExternalizer.write((Element)element, (String)"path", (String)ExternalizablePath.urlValue((String)this.scriptPath));
        JDOMExternalizer.write((Element)element, (String)"vmparams", (String)this.vmParams);
        JDOMExternalizer.write((Element)element, (String)"params", (String)this.scriptParams);
        JDOMExternalizer.write((Element)element, (String)"workDir", (String)ExternalizablePath.urlValue((String)this.workDir));
        JDOMExternalizer.write((Element)element, (String)"debug", (boolean)this.isDebugEnabled);
        if (this.isAddClasspathToTheRunner) {
            JDOMExternalizer.write((Element)element, (String)"addClasspath", (boolean)true);
        }
        JDOMExternalizer.writeMap((Element)element, this.envs, null, (String)"env");
        if (this.myAlternativeJrePathEnabled) {
            JDOMExternalizer.write((Element)element, (String)"alternativeJrePathEnabled", (boolean)true);
            if (StringUtil.isNotEmpty((String)this.myAlternativeJrePath)) {
                JDOMExternalizer.write((Element)element, (String)"alternativeJrePath", (String)this.myAlternativeJrePath);
            }
        }
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration", "getState"));
        }
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration", "getState"));
        }
        final VirtualFile scriptFile = ScriptFileUtil.findScriptFileByPath((String)this.getScriptPath());
        assert (scriptFile != null);
        final GroovyScriptRunner scriptRunner = this.getScriptRunner();
        assert (scriptRunner != null);
        return new JavaCommandLineState(environment){

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                OSProcessHandler handler = super.startProcess();
                handler.setShouldDestroyProcessRecursively(true);
                if (scriptRunner.shouldRefreshAfterFinish()) {
                    handler.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(ProcessEvent event) {
                            if (!ApplicationManager.getApplication().isDisposed()) {
                                VirtualFileManager.getInstance().asyncRefresh(null);
                            }
                        }
                    });
                }
                OSProcessHandler oSProcessHandler = handler;
                if (oSProcessHandler == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$1", "startProcess"));
                }
                return oSProcessHandler;
            }

            protected JavaParameters createJavaParameters() throws ExecutionException {
                Module module = GroovyScriptRunConfiguration.this.getModule();
                boolean tests = ProjectRootManager.getInstance((Project)GroovyScriptRunConfiguration.this.getProject()).getFileIndex().isInTestSourceContent(scriptFile);
                String jrePath = GroovyScriptRunConfiguration.this.isAlternativeJrePathEnabled() ? GroovyScriptRunConfiguration.this.getAlternativeJrePath() : null;
                JavaParameters params = new JavaParameters();
                params.setUseClasspathJar(true);
                params.setDefaultCharset(GroovyScriptRunConfiguration.this.getProject());
                params.setJdk(module == null ? JavaParametersUtil.createProjectJdk((Project)GroovyScriptRunConfiguration.this.getProject(), (String)jrePath) : JavaParametersUtil.createModuleJdk((Module)module, (!tests ? 1 : 0) != 0, (String)jrePath));
                ProgramParametersUtil.configureConfiguration((SimpleProgramParameters)params, (CommonProgramRunConfigurationParameters)new CommonProgramRunConfigurationParametersDelegate((CommonProgramRunConfigurationParameters)GroovyScriptRunConfiguration.this){

                    @Override
                    @Nullable
                    public String getProgramParameters() {
                        return null;
                    }
                });
                scriptRunner.configureCommandLine(params, module, tests, scriptFile, GroovyScriptRunConfiguration.this);
                return params;
            }
        };
    }

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        if (this.scriptPath == null || !this.scriptPath.equals(GroovyScriptRunConfiguration.getPathByElement(element))) {
            return null;
        }
        PsiClass classToRun = GroovyRunnerPsiUtil.getRunningClass(element);
        if (element instanceof GroovyFile) {
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$2", "elementRenamedOrMoved"));
                    }
                    if (newElement instanceof GroovyFile) {
                        GroovyFile file = (GroovyFile)newElement;
                        GroovyScriptRunConfiguration.this.setScriptPath(ScriptFileUtil.getScriptFilePath((VirtualFile)file.getVirtualFile()));
                    }
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$2", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$2", "undoElementMovedOrRenamed"));
                    }
                    this.elementRenamedOrMoved(newElement);
                }
            };
        }
        if (element instanceof PsiClass && element.getManager().areElementsEquivalent(element, (PsiElement)classToRun)) {
            return new RefactoringElementAdapter(){

                protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$3", "elementRenamedOrMoved"));
                    }
                    GroovyScriptRunConfiguration.this.setName(((PsiClass)newElement).getName());
                }

                public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                    if (newElement == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$3", "undoElementMovedOrRenamed"));
                    }
                    if (oldQualifiedName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$3", "undoElementMovedOrRenamed"));
                    }
                    this.elementRenamedOrMoved(newElement);
                }
            };
        }
        return null;
    }

    @Nullable
    private static String getPathByElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration", "getPathByElement"));
        }
        PsiFile file = element.getContainingFile();
        if (file == null) {
            return null;
        }
        VirtualFile vfile = file.getVirtualFile();
        if (vfile == null) {
            return null;
        }
        return vfile.getPath();
    }

    public static JavaParameters createJavaParametersWithSdk(@Nullable Module module) {
        Sdk sdk;
        JavaParameters params = new JavaParameters();
        params.setCharset(null);
        if (module != null && (sdk = ModuleRootManager.getInstance((Module)module).getSdk()) != null && sdk.getSdkType() instanceof JavaSdkType) {
            params.setJdk(sdk);
        }
        if (params.getJdk() == null) {
            params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
        }
        return params;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        GroovyRunConfigurationEditor groovyRunConfigurationEditor = new GroovyRunConfigurationEditor(this.getProject());
        if (groovyRunConfigurationEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration", "getConfigurationEditor"));
        }
        return groovyRunConfigurationEditor;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        String scriptPath = this.getScriptPath();
        VirtualFile script = ScriptFileUtil.findScriptFileByPath((String)scriptPath);
        if (script == null) {
            throw new RuntimeConfigurationException("Cannot find script " + scriptPath);
        }
        GroovyScriptRunner scriptRunner = this.getScriptRunner();
        if (scriptRunner == null) {
            throw new RuntimeConfigurationException("Unknown script type " + scriptPath);
        }
        scriptRunner.ensureRunnerConfigured(this);
        PsiFile file = PsiManager.getInstance((Project)this.getProject()).findFile(script);
        PsiClass toRun = GroovyRunnerPsiUtil.getRunningClass((PsiElement)file);
        if (toRun == null) {
            throw new RuntimeConfigurationWarning(GroovyBundle.message("class.does.not.exist", new Object[0]));
        }
        if (toRun instanceof GrTypeDefinition) {
            if (!GroovyRunnerPsiUtil.canBeRunByGroovy(toRun)) {
                throw new RuntimeConfigurationWarning(GroovyBundle.message("class.cannot.be.executed", new Object[0]));
            }
        } else {
            throw new RuntimeConfigurationWarning(GroovyBundle.message("script.file.is.not.groovy.file", new Object[0]));
        }
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this);
    }

    public void setVMParameters(String value) {
        this.vmParams = value;
    }

    public String getVMParameters() {
        return this.vmParams;
    }

    public boolean isAlternativeJrePathEnabled() {
        return this.myAlternativeJrePathEnabled;
    }

    public void setAlternativeJrePathEnabled(boolean alternativeJrePathEnabled) {
        this.myAlternativeJrePathEnabled = alternativeJrePathEnabled;
    }

    @Nullable
    public String getAlternativeJrePath() {
        return this.myAlternativeJrePath;
    }

    public void setAlternativeJrePath(@Nullable String alternativeJrePath) {
        this.myAlternativeJrePath = alternativeJrePath;
    }

    public String getRunClass() {
        return null;
    }

    public String getPackage() {
        return null;
    }

    public void setProgramParameters(@Nullable String value) {
        this.scriptParams = value;
    }

    public String getProgramParameters() {
        return this.scriptParams;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.workDir = value;
    }

    public String getWorkingDirectory() {
        return this.workDir;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration", "setEnvs"));
        }
        this.envs.clear();
        this.envs.putAll(envs);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.envs;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration", "getEnvs"));
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.passParentEnv = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.passParentEnv;
    }

    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    public void setDebugEnabled(boolean debugEnabled) {
        this.isDebugEnabled = debugEnabled;
    }

    public boolean isAddClasspathToTheRunner() {
        return this.isAddClasspathToTheRunner;
    }

    public void setAddClasspathToTheRunner(boolean addClasspathToTheRunner) {
        this.isAddClasspathToTheRunner = addClasspathToTheRunner;
    }

    @Nullable
    public String getScriptPath() {
        return this.scriptPath;
    }

    public void setScriptPath(@Nullable String scriptPath) {
        this.scriptPath = scriptPath;
    }

    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope superScope = super.getSearchScope();
        String path = this.getScriptPath();
        if (path == null) {
            return superScope;
        }
        final VirtualFile scriptFile = LocalFileSystem.getInstance().findFileByPath(path);
        if (scriptFile == null) {
            return superScope;
        }
        GlobalSearchScope fileScope = GlobalSearchScope.fileScope((Project)this.getProject(), (VirtualFile)scriptFile);
        if (superScope == null) {
            return fileScope;
        }
        return new DelegatingGlobalSearchScope(fileScope.union((SearchScope)superScope)){

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$4", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "org/jetbrains/plugins/groovy/runner/GroovyScriptRunConfiguration$4", "compare"));
                }
                if (file1.equals(scriptFile)) {
                    return 1;
                }
                if (file2.equals(scriptFile)) {
                    return -1;
                }
                return super.compare(file1, file2);
            }
        };
    }
}

