/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IdrefReference
implements PsiReference {
    private final XmlAttributeValue referenceElement;

    IdrefReference(XmlAttributeValue referenceElement) {
        this.referenceElement = referenceElement;
    }

    public PsiElement getElement() {
        return this.referenceElement;
    }

    public TextRange getRangeInElement() {
        return ElementManipulators.getManipulator((PsiElement)this.referenceElement).getRangeInElement((PsiElement)this.referenceElement);
    }

    @Nullable
    public PsiElement resolve() {
        String text = this.referenceElement.getText();
        if (text.length() - 1 < 1) {
            return null;
        }
        String strippedText = text.substring(1, text.length() - 1);
        return IdrefReference.findIDAttribute(this.referenceElement.getContainingFile(), strippedText);
    }

    private static XmlAttribute findIDAttribute(PsiFile containingFile, final String strippedText) {
        final XmlAttribute[] out = new XmlAttribute[1];
        XmlRecursiveElementVisitor visitor = new XmlRecursiveElementVisitor(){

            public void visitElement(PsiElement psiElement) {
                if (out[0] != null) {
                    return;
                }
                super.visitElement(psiElement);
            }

            public void visitXmlAttribute(XmlAttribute xmlAttribute) {
                if (out[0] != null) {
                    return;
                }
                super.visitXmlAttribute(xmlAttribute);
                if ("id".equalsIgnoreCase(xmlAttribute.getName()) && strippedText.equals(xmlAttribute.getValue())) {
                    out[0] = xmlAttribute;
                }
            }
        };
        containingFile.accept((PsiElementVisitor)visitor);
        return out[0];
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.referenceElement.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/references/IdrefReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XmlAttribute attribute = (XmlAttribute)this.referenceElement.getParent();
        attribute.setValue(newElementName);
        XmlAttributeValue out = attribute.getValueElement();
        assert (out != null);
        return out;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/sixrr/xrp/references/IdrefReference", "bindToElement"));
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (!(element instanceof XmlAttribute)) {
            return false;
        }
        XmlAttribute xmlAttribute = (XmlAttribute)element;
        if (!"id".equalsIgnoreCase(xmlAttribute.getName())) {
            return false;
        }
        return element.equals(this.resolve());
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/references/IdrefReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }
}

