/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.renameattribute;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import com.sixrr.xrp.renameattribute.RenameAttribute;
import com.sixrr.xrp.renameattribute.RenameAttributeUsageViewDescriptor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RenameAttributeProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlAttribute attribute;
    private final String newAttributeName;
    private final Context context;

    RenameAttributeProcessor(XmlAttribute attribute, String newAttributeName, Context context) {
        super(attribute.getProject());
        this.attribute = attribute;
        this.newAttributeName = newAttributeName;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfos", "com/sixrr/xrp/renameattribute/RenameAttributeProcessor", "createUsageViewDescriptor"));
        }
        RenameAttributeUsageViewDescriptor renameAttributeUsageViewDescriptor = new RenameAttributeUsageViewDescriptor(this.attribute, usageInfos);
        if (renameAttributeUsageViewDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/xrp/renameattribute/RenameAttributeProcessor", "createUsageViewDescriptor"));
        }
        return renameAttributeUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/sixrr/xrp/renameattribute/RenameAttributeProcessor", "findUsages"));
        }
        XmlTag tag = this.attribute.getParent();
        String tagName = tag.getName();
        String attributeName = this.attribute.getName();
        String attributeNamespace = this.attribute.getNamespace();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            XmlAttribute attribute = xmlTag.getAttribute(attributeName, attributeNamespace);
            if (attribute == null) continue;
            usages.add(new RenameAttribute(attribute, this.newAttributeName));
        }
    }

    protected String getCommandName() {
        return "Rename attribute " + this.attribute.getName();
    }
}

