/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSplitDeclarationAndInitializationIntention
extends JSIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = JSVariablesWithInitializerPredicate.PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndInitializationIntention", "processIntention"));
        }
        assert (element instanceof JSVarStatement);
        ASTNode node = element.getNode();
        if (node == null) {
            return;
        }
        ASTNode varModifier = node.findChildByType(JSTokenTypes.VAR_MODIFIERS);
        String varStatementKeyword = varModifier == null ? "var " : varModifier.getText() + " ";
        StringBuilder declarationBuffer = new StringBuilder();
        ArrayList<String> initializations = new ArrayList<String>();
        String lineTail = JSCodeStyleSettings.getSemicolon((Project)element.getProject()) + "\n";
        String docComment = "";
        PsiElement child = element.getFirstChild();
        if (child instanceof JSDocComment) {
            String elementText = element.getText();
            docComment = elementText.substring(0, elementText.indexOf(varStatementKeyword, child.getStartOffsetInParent() + child.getTextLength()));
        }
        PsiFile containingFile = element.getContainingFile();
        SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)containingFile.getProject()).createSmartPsiElementPointer((PsiElement)((JSVarStatement)element));
        for (int i = 0; i < ((JSVarStatement)pointer.getElement()).getVariables().length; ++i) {
            JSVariable variable = ((JSVarStatement)pointer.getElement()).getVariables()[i];
            declarationBuffer.append(declarationBuffer.length() == 0 ? docComment + varStatementKeyword : ",").append(variable.getName());
            String s = JSSplitDeclarationAndInitializationIntention.getTypeString(containingFile, (JSInitializerOwner)variable);
            if (s != null) {
                declarationBuffer.append(":").append(s);
            }
            if (variable.getInitializer() == null) continue;
            initializations.add(variable.getName() + '=' + variable.getInitializer().getText() + lineTail);
        }
        declarationBuffer.append(lineTail);
        this.doReplacement(declarationBuffer.toString(), initializations, (JSVarStatement)pointer.getElement());
    }

    @Nullable
    private static String getTypeString(PsiFile containingFile, JSInitializerOwner element) {
        JSType result;
        JSType type = JSPsiImplUtils.getTypeFromDeclaration((JSElement)element);
        if (type != null) {
            return type.getTypeText(JSType.TypeTextFormat.CODE);
        }
        DialectOptionHolder holder = DialectDetector.dialectOfFile((PsiFile)containingFile);
        if (holder == null) {
            return null;
        }
        JSType jSType = holder.isECMA4 ? JSResolveUtil.getQualifiedExpressionJSType((JSExpression)element.getInitializer(), (PsiFile)containingFile) : (result = element instanceof JSTypeDeclarationOwner ? ((JSTypeDeclarationOwner)element).getType() : JSResolveUtil.getExpressionJSType((JSExpression)element.getInitializer()));
        if (result == null) {
            return null;
        }
        return JSVariablesWithInitializerPredicate.formatType((JSType)result, (PsiElement)element);
    }

    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        JSLanguageDialect dialect = DialectDetector.languageDialectOfElement((PsiElement)oldVarStatement.getContainingFile());
        Project project = oldVarStatement.getProject();
        JSStatement newStatement = (JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)declarations, (JSLanguageDialect)dialect).getPsi();
        newStatement = oldVarStatement.replace(newStatement);
        int startOffset = newStatement.getTextOffset();
        for (String initialization : initializations) {
            newStatement = newStatement.addStatementAfter((JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)initialization, (JSLanguageDialect)dialect).getPsi());
        }
        int endOffset = newStatement.getTextOffset() + newStatement.getTextLength();
        CodeStyleManager.getInstance((Project)project).reformatText(newStatement.getContainingFile(), startOffset, endOffset);
    }
}

