/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.inspections.JSVariablesWithInitializerPredicate;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.List;
import org.intellij.idea.lang.javascript.intention.initialization.JSSplitDeclarationAndInitializationIntention;
import org.jetbrains.annotations.NotNull;

public class JSSplitDeclarationAndMoveToScopeStartIntention
extends JSSplitDeclarationAndInitializationIntention {
    private static final JSElementPredicate PREDICATE = new JSVariablesWithInitializerPredicate(){

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention$1", "satisfiedBy"));
            }
            return super.satisfiedBy(element) && JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)element) != element;
        }
    };

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSSplitDeclarationAndMoveToScopeStartIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }

    @Override
    protected void doReplacement(String declarations, List<String> initializations, JSVarStatement oldVarStatement) {
        PsiFile containingFile = oldVarStatement.getContainingFile();
        Project project = containingFile.getProject();
        JSLanguageDialect dialect = JSUtils.getDialect((PsiFile)containingFile);
        PsiElement newStatement = JSChangeUtil.createStatementFromText((Project)project, (String)declarations, (JSLanguageDialect)dialect).getPsi();
        JSStatement newStatementAnchor = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)oldVarStatement);
        if (newStatementAnchor == null) {
            newStatementAnchor = oldVarStatement;
        }
        newStatement = newStatementAnchor.getParent().addBefore(newStatement, (PsiElement)newStatementAnchor);
        int startOffset = newStatement.getTextOffset();
        JSStatement assignmentStatement = null;
        boolean first = true;
        for (String initialization : initializations) {
            if (first) {
                first = false;
                JSStatement newInitializer = (JSStatement)JSChangeUtil.createStatementFromText((Project)oldVarStatement.getProject(), (String)initialization, (JSLanguageDialect)DialectDetector.languageDialectOfElement((PsiElement)oldVarStatement)).getPsi();
                assignmentStatement = oldVarStatement.replace(newInitializer);
                continue;
            }
            assignmentStatement = assignmentStatement.addStatementAfter((JSStatement)JSChangeUtil.createStatementFromText((Project)project, (String)initialization, (JSLanguageDialect)dialect).getPsi());
        }
        if (assignmentStatement == null) {
            return;
        }
        int endOffset = assignmentStatement.getTextOffset() + assignmentStatement.getTextLength();
        CodeStyleManager.getInstance((Project)project).reformatText(newStatement.getContainingFile(), startOffset, endOffset);
    }
}

