/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.google.common.base.Splitter;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.GemUtil;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;

public class CompassUtil {
    public static final String COMPASS_LIBRARY_NAME = "compass-library";
    public static final String COMPASS_EXECUTABLE_BASE_NAME = "compass";
    public static final String COMPASS_EXECUTABLE_BASE_NAME_WIN = "compass.bat";
    public static final String COMPASS_EXECUTABLE_RELATIVE_PATH = "bin/compass";
    public static final String COMPASS_EXECUTABLE_RELATIVE_PATH_WIN = "bin/compass.bat";
    public static final String COMPASS_STYLESHEETS_RELATIVE_PATH = "../../frameworks/compass/stylesheets/";
    public static final String CONFIG_RB = "config.rb";
    private static final Splitter COMPASS_IMPORTS_RESULT_SPLITTER = Splitter.on((char)' ').trimResults();
    private static final String COMPASS_IMPORTS_NOTIFICATION_ID = "Compass Execution Failures";
    private static final String GEMS_PATH_PART = "/gems/";
    private static final String COMPASS_LOGGING_CATEGORY = "compass";

    @NotNull
    public static List<String> getExecutableFilesVariants() {
        List<String> list = SystemInfo.isWindows ? GemUtil.listPossibleExecutableFilePaths(COMPASS_EXECUTABLE_BASE_NAME_WIN, COMPASS_EXECUTABLE_RELATIVE_PATH_WIN) : GemUtil.listPossibleExecutableFilePaths("compass", COMPASS_EXECUTABLE_RELATIVE_PATH);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "getExecutableFilesVariants"));
        }
        return list;
    }

    @NotNull
    public static List<String> getConfigFileVariants(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "getConfigFileVariants"));
        }
        List list = ContainerUtil.skipNulls((Collection)ContainerUtil.map((Object[])FilenameIndex.getFilesByName((Project)module.getProject(), (String)CONFIG_RB, (GlobalSearchScope)module.getModuleContentScope()), file -> {
            VirtualFile virtualFile = file.getVirtualFile();
            return virtualFile != null ? virtualFile.getPath() : null;
        }));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "getConfigFileVariants"));
        }
        return list;
    }

    public static boolean runCompassImportsAndProcessPaths(@NotNull Module module, @Nullable VirtualFile configFile, @NotNull Processor<String> pathProcessor, boolean showNotificationOnError) {
        ProcessOutput output;
        VirtualFile workingDirectory;
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "runCompassImportsAndProcessPaths"));
        }
        if (pathProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathProcessor", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "runCompassImportsAndProcessPaths"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            VirtualFile stylesheet;
            String compassFileUrl = VfsUtilCore.pathToUrl((String)CompassSettings.getInstance(module).getCompassExecutableFilePath());
            VirtualFile compassFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(compassFileUrl);
            if (compassFile != null && (stylesheet = compassFile.findFileByRelativePath(COMPASS_STYLESHEETS_RELATIVE_PATH)) != null) {
                pathProcessor.process((Object)stylesheet.getPath());
                return true;
            }
            return false;
        }
        String workingDirectoryPath = null;
        if (configFile != null && (workingDirectory = configFile.getParent()) != null && workingDirectory.isDirectory()) {
            workingDirectoryPath = workingDirectory.getPath();
        }
        try {
            CompassSettings settings = CompassSettings.getInstance(module);
            String executablePath = settings.getCompassExecutableFilePath();
            if (executablePath.trim().isEmpty()) {
                return false;
            }
            output = SassRubyIntegrationHelper.getInstance().execScript(module, workingDirectoryPath, executablePath, "imports");
        }
        catch (ExecutionException e) {
            output = new ProcessOutput(1);
            output.appendStderr(e.getMessage());
        }
        if (output.getExitCode() == 0) {
            CompassUtil.processCompassImportsOutput(output.getStdout(), pathProcessor);
            return true;
        }
        if (showNotificationOnError) {
            String notificationMessage = configFile != null ? SASSBundle.message("compass.run.imports.fail.with.config", configFile.getPath()) : SASSBundle.message("compass.run.imports.fail");
            Notifications.Bus.notify((Notification)new Notification(COMPASS_IMPORTS_NOTIFICATION_ID, "Compass", notificationMessage, NotificationType.WARNING));
        }
        Logger.getInstance((String)"compass").info("Failed to run compass imports\nResult code: " + output + "\nout:\n" + output.getStdout() + "\nerr:\n" + output.getStderr());
        return false;
    }

    public static void processCompassImportsOutput(@NotNull String output, @NotNull Processor<String> pathProcessor) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "processCompassImportsOutput"));
        }
        if (pathProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathProcessor", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "processCompassImportsOutput"));
        }
        Iterator wordsIterator = COMPASS_IMPORTS_RESULT_SPLITTER.split((CharSequence)output).iterator();
        if (!wordsIterator.hasNext()) {
            Logger.getInstance((String)"compass").info("Failed to run compass imports\n" + output);
        }
        while (wordsIterator.hasNext()) {
            String newPath;
            if (!"-I".equals(wordsIterator.next()) || !wordsIterator.hasNext() || (newPath = (String)wordsIterator.next()).isEmpty()) continue;
            pathProcessor.process((Object)newPath);
        }
    }

    public static void updateCompassLibraries(@NotNull CompassSettings compassSettings) {
        if (compassSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compassSettings", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "updateCompassLibraries"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Module module = compassSettings.getModule();
        if (module.isDisposed()) {
            return;
        }
        List<String> importPaths = compassSettings.getImportPaths();
        Collection<VirtualFile> libraryRoots = CompassUtil.getLibraryRootsFromImportPaths(module, importPaths);
        ModifiableModelsProvider modelsProvider = ModifiableModelsProvider.SERVICE.getInstance();
        ModifiableRootModel model = modelsProvider.getModuleModifiableModel(module);
        LibraryOrderEntry compassLibraryEntry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model, (String)COMPASS_LIBRARY_NAME);
        if (!libraryRoots.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (compassLibraryEntry != null) {
                    Library compassLibrary = compassLibraryEntry.getLibrary();
                    if (compassLibrary != null) {
                        CompassUtil.fillLibrary(module, compassLibrary, libraryRoots);
                    } else {
                        model.removeOrderEntry((OrderEntry)compassLibraryEntry);
                        CompassUtil.createAndFillLibrary(module, model, libraryRoots);
                    }
                } else {
                    CompassUtil.createAndFillLibrary(module, model, libraryRoots);
                }
                modelsProvider.commitModuleModifiableModel(model);
            });
        } else {
            CompassUtil.disposeModel(modelsProvider, model);
            CompassUtil.removeCompassLibraryIfNeeded(module);
        }
    }

    public static void removeCompassLibraryIfNeeded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "removeCompassLibraryIfNeeded"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (module.isDisposed()) {
            return;
        }
        ModifiableModelsProvider modelsProvider = ModifiableModelsProvider.SERVICE.getInstance();
        ModifiableRootModel model = modelsProvider.getModuleModifiableModel(module);
        LibraryOrderEntry compassLibraryEntry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)model, (String)COMPASS_LIBRARY_NAME);
        if (compassLibraryEntry != null) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Library library = compassLibraryEntry.getLibrary();
                if (library != null) {
                    LibraryTable table = library.getTable();
                    if (table != null) {
                        table.removeLibrary(library);
                        model.removeOrderEntry((OrderEntry)compassLibraryEntry);
                        modelsProvider.commitModuleModifiableModel(model);
                    }
                } else {
                    modelsProvider.disposeModuleModifiableModel(model);
                }
            });
        } else {
            CompassUtil.disposeModel(modelsProvider, model);
        }
    }

    @NotNull
    private static Collection<VirtualFile> getLibraryRootsFromImportPaths(@NotNull Module module, @NotNull List<String> importPaths) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "getLibraryRootsFromImportPaths"));
        }
        if (importPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPaths", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "getLibraryRootsFromImportPaths"));
        }
        ArrayList libraryRoots = ContainerUtil.newArrayList();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (importPaths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPaths", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "lambda$getLibraryRootsFromImportPaths$3"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "lambda$getLibraryRootsFromImportPaths$3"));
            }
            for (String path : importPaths) {
                int indexOfNextSlash;
                String gemRootPath;
                VirtualFile gemRoot;
                VirtualFile importRoot = VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
                int indexOfGemsDir = path.lastIndexOf(GEMS_PATH_PART);
                if (indexOfGemsDir >= 0 && (gemRoot = VfsUtil.findFileByIoFile((File)new File(gemRootPath = (indexOfNextSlash = path.indexOf(47, indexOfGemsDir + GEMS_PATH_PART.length())) >= 0 ? path.substring(0, indexOfNextSlash) : path), (boolean)true)) != null) {
                    if (SassRubyIntegrationHelper.getInstance().isGemInstalled(gemRoot.getUrl(), module)) continue;
                    libraryRoots.add(gemRoot);
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)libraryRoots, (Object)importRoot);
            }
        });
        ArrayList arrayList = libraryRoots;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "getLibraryRootsFromImportPaths"));
        }
        return arrayList;
    }

    private static void disposeModel(@NotNull ModifiableModelsProvider modelsProvider, @NotNull ModifiableRootModel model) {
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "disposeModel"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "disposeModel"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (modelsProvider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "lambda$disposeModel$4"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "lambda$disposeModel$4"));
            }
            modelsProvider.disposeModuleModifiableModel(model);
        });
    }

    private static void fillLibrary(@NotNull Module module, @NotNull Library compassLibrary, @NotNull Collection<VirtualFile> importRoots) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "fillLibrary"));
        }
        if (compassLibrary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compassLibrary", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "fillLibrary"));
        }
        if (importRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importRoots", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "fillLibrary"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        Library.ModifiableModel libraryModel = compassLibrary.getModifiableModel();
        for (String root : libraryModel.getUrls(OrderRootType.CLASSES)) {
            libraryModel.removeRoot(root, OrderRootType.CLASSES);
        }
        for (VirtualFile importRoot : importRoots) {
            if (ModuleUtilCore.projectContainsFile((Project)module.getProject(), (VirtualFile)importRoot, (boolean)false)) continue;
            libraryModel.addRoot(importRoot, OrderRootType.CLASSES);
        }
        libraryModel.commit();
    }

    private static LibraryOrderEntry createAndFillLibrary(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull Collection<VirtualFile> importRoots) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "createAndFillLibrary"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "createAndFillLibrary"));
        }
        if (importRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importRoots", "org/jetbrains/plugins/sass/extensions/compass/CompassUtil", "createAndFillLibrary"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(module.getProject());
        Library compassLibrary = libraryTable.createLibrary(COMPASS_LIBRARY_NAME);
        CompassUtil.fillLibrary(module, compassLibrary, importRoots);
        return model.addLibraryEntry(compassLibrary);
    }
}

