/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexableSetContributor;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.stdlib.SassScssStubMarker;

public class SassScssIndexedRootProvider
extends IndexableSetContributor {
    private static final Logger LOG = Logger.getInstance(SassScssIndexedRootProvider.class);
    private volatile Set<VirtualFile> myAdditionalRoots;

    @NotNull
    public Set<VirtualFile> getAdditionalRootsToIndex() {
        Set<VirtualFile> result = this.myAdditionalRoots;
        if (result == null || result.isEmpty() || VfsUtilCore.hasInvalidFiles(result)) {
            this.myAdditionalRoots = result = SassScssIndexedRootProvider.findStdlibStubFiles();
        }
        Set<VirtualFile> set = result;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/index/SassScssIndexedRootProvider", "getAdditionalRootsToIndex"));
        }
        return set;
    }

    public static SassScssIndexedRootProvider getInstance() {
        return (SassScssIndexedRootProvider)((Object)IndexableSetContributor.EP_NAME.findExtension(SassScssIndexedRootProvider.class));
    }

    private static Set<VirtualFile> findStdlibStubFiles() {
        URL resource = SassScssStubMarker.class.getResource("sass_functions.scss");
        assert (resource != null);
        VirtualFile result = VfsUtil.findFileByURL((URL)resource);
        if (result == null) {
            LOG.error("Cannot find sass stdlib file in ", new String[]{resource.getFile()});
        }
        return result != null ? Collections.singleton(result) : Collections.emptySet();
    }
}

