/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Vector;
import org.jetbrains.annotations.NonNls;

public class LoggingSftpChannel
extends ChannelSftp {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.plugins.webDeployment.sftp");
    private final ChannelSftp myPeer;

    public LoggingSftpChannel(ChannelSftp peer) {
        this.myPeer = peer;
    }

    public static boolean isEnabled() {
        return LOG.isDebugEnabled();
    }

    private static void log(@NonNls String pattern, Object ... arguments) {
        LoggingSftpChannel.log(MessageFormat.format(pattern, arguments));
    }

    private static void log(@NonNls Object o) {
        LOG.debug(o.toString());
    }

    public void start() throws JSchException {
        LoggingSftpChannel.log("start()");
        this.myPeer.start();
    }

    public void quit() {
        LoggingSftpChannel.log("quit()");
        this.myPeer.quit();
    }

    public void exit() {
        LoggingSftpChannel.log("exit()");
        this.myPeer.exit();
    }

    public void lcd(String path) throws SftpException {
        LoggingSftpChannel.log("lcd \"{0}\"", path);
        this.myPeer.lcd(path);
    }

    public void cd(String path) throws SftpException {
        LoggingSftpChannel.log("cd \"{0}\"", path);
        this.myPeer.cd(path);
    }

    public void put(String src, String dst) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\" -> \"{1}\"", src, dst);
        this.myPeer.put(src, dst);
    }

    public void put(String src, String dst, int mode) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\" -> \"{1}\", mode={2}", src, dst, mode);
        this.myPeer.put(src, dst, mode);
    }

    public void put(String src, String dst, SftpProgressMonitor monitor) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\" -> \"{1}\"", src, dst);
        this.myPeer.put(src, dst, monitor);
    }

    public void put(String src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\" -> \"{1}\", mode={2}", src, dst, mode);
        this.myPeer.put(src, dst, monitor, mode);
    }

    public void put(InputStream src, String dst) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\"", dst);
        this.myPeer.put(src, dst);
    }

    public void put(InputStream src, String dst, int mode) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\", mode={1}", dst, mode);
        this.myPeer.put(src, dst, mode);
    }

    public void put(InputStream src, String dst, SftpProgressMonitor monitor) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\"", dst);
        this.myPeer.put(src, dst, monitor);
    }

    public void put(InputStream src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\", mode={1}", dst, mode);
        this.myPeer.put(src, dst, monitor, mode);
    }

    public void _put(InputStream src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        LoggingSftpChannel.log("_put \"{0}\", mode={1}", dst, mode);
        this.myPeer._put(src, dst, monitor, mode);
    }

    public OutputStream put(String dst) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\"", dst);
        return this.myPeer.put(dst);
    }

    public OutputStream put(String dst, int mode) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\", mode={1}", dst, mode);
        return this.myPeer.put(dst, mode);
    }

    public OutputStream put(String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\", mode={1}", dst, mode);
        return this.myPeer.put(dst, monitor, mode);
    }

    public OutputStream put(String dst, SftpProgressMonitor monitor, int mode, long offset) throws SftpException {
        LoggingSftpChannel.log("put \"{0}\", mode={1}, offset={2}", dst, mode, offset);
        return this.myPeer.put(dst, monitor, mode, offset);
    }

    public void get(String src, String dst) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\" -> \"{1}\"", src, dst);
        this.myPeer.get(src, dst);
    }

    public void get(String src, String dst, SftpProgressMonitor monitor) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\" -> \"{1}\"", src, dst);
        this.myPeer.get(src, dst, monitor);
    }

    public void get(String src, String dst, SftpProgressMonitor monitor, int mode) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\" -> \"{1}\", mode={2}", src, dst, mode);
        this.myPeer.get(src, dst, monitor, mode);
    }

    public void get(String src, OutputStream dst) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\"", src);
        this.myPeer.get(src, dst);
    }

    public void get(String src, OutputStream dst, SftpProgressMonitor monitor) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\"", src);
        this.myPeer.get(src, dst, monitor);
    }

    public void get(String src, OutputStream dst, SftpProgressMonitor monitor, int mode, long skip) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\", mode={1}, skip={2}", src, mode, skip);
        this.myPeer.get(src, dst, monitor, mode, skip);
    }

    public InputStream get(String src) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\"", src);
        return this.myPeer.get(src);
    }

    public InputStream get(String src, SftpProgressMonitor monitor) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\"", src);
        return this.myPeer.get(src, monitor);
    }

    public InputStream get(String src, int mode) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\", mode={1}", src, mode);
        return this.myPeer.get(src, mode);
    }

    public InputStream get(String src, SftpProgressMonitor monitor, int mode) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\", mode={1}", src, mode);
        return this.myPeer.get(src, monitor, mode);
    }

    public InputStream get(String src, SftpProgressMonitor monitor, long skip) throws SftpException {
        LoggingSftpChannel.log("get \"{0}\", skip={1}", src, skip);
        return this.myPeer.get(src, monitor, skip);
    }

    public Vector ls(String path) throws SftpException {
        LoggingSftpChannel.log("ls \"" + path + "\"");
        Vector v = this.myPeer.ls(path);
        StringBuilder s = new StringBuilder(v.size() + " item(s):");
        for (Object o : v) {
            s.append("\n").append(o);
        }
        LoggingSftpChannel.log(s.toString());
        return v;
    }

    public String readlink(String path) throws SftpException {
        LoggingSftpChannel.log("readlink \"{0}\"", path);
        String r = this.myPeer.readlink(path);
        LoggingSftpChannel.log(r);
        return r;
    }

    public void symlink(String oldpath, String newpath) throws SftpException {
        LoggingSftpChannel.log("symlink \"{0}\" -> \"{1}\"", oldpath, newpath);
        this.myPeer.symlink(oldpath, newpath);
    }

    public void rename(String oldpath, String newpath) throws SftpException {
        LoggingSftpChannel.log("rename \"{0}\" -> \"{1}\"", oldpath, newpath);
        this.myPeer.rename(oldpath, newpath);
    }

    public void rm(String path) throws SftpException {
        LoggingSftpChannel.log("rm \"{0}\"", path);
        this.myPeer.rm(path);
    }

    public void chgrp(int gid, String path) throws SftpException {
        LoggingSftpChannel.log("chgrp \"{0}\", {1}", path, gid);
        this.myPeer.chgrp(gid, path);
    }

    public void chown(int uid, String path) throws SftpException {
        LoggingSftpChannel.log("chown \"{0}\", {1}", path, uid);
        this.myPeer.chown(uid, path);
    }

    public void chmod(int permissions, String path) throws SftpException {
        LoggingSftpChannel.log("chmod \"{0}\", {1}", path, permissions);
        this.myPeer.chmod(permissions, path);
    }

    public void setMtime(String path, int mtime) throws SftpException {
        LoggingSftpChannel.log("setMtime \"{0}\", {1}", path, mtime);
        this.myPeer.setMtime(path, mtime);
    }

    public void rmdir(String path) throws SftpException {
        LoggingSftpChannel.log("rmdir \"{0}\"", path);
        this.myPeer.rmdir(path);
    }

    public void mkdir(String path) throws SftpException {
        LoggingSftpChannel.log("mkdir \"{0}\"", path);
        this.myPeer.mkdir(path);
    }

    public SftpATTRS stat(String path) throws SftpException {
        LoggingSftpChannel.log("stat \"{0}\"", path);
        SftpATTRS r = this.myPeer.stat(path);
        LoggingSftpChannel.log("{0}, mtime {1}", r, r.getMTime());
        return r;
    }

    public SftpATTRS lstat(String path) throws SftpException {
        LoggingSftpChannel.log("lstat \"{0}\"", path);
        SftpATTRS r = this.myPeer.lstat(path);
        LoggingSftpChannel.log("{0}, mtime {1}", r, r.getMTime());
        return r;
    }

    public void setStat(String path, SftpATTRS attr) throws SftpException {
        LoggingSftpChannel.log("setStat \"{0}\", {1}, mtime {2}", path, attr, attr.getMTime());
        this.myPeer.setStat(path, attr);
    }

    public String pwd() throws SftpException {
        String r = this.myPeer.pwd();
        LoggingSftpChannel.log("pwd: \"{0}\"", r);
        return r;
    }

    public String lpwd() {
        String r = this.myPeer.lpwd();
        LoggingSftpChannel.log("lpwd: \"{0}\"", r);
        return r;
    }

    public String version() {
        String r = this.myPeer.version();
        LoggingSftpChannel.log("version: \"{0}\"", r);
        return r;
    }

    public String getHome() throws SftpException {
        String r = this.myPeer.getHome();
        LoggingSftpChannel.log("home: \"{0}\"", r);
        return r;
    }

    public void disconnect() {
        LoggingSftpChannel.log("disconnect()");
        this.myPeer.disconnect();
    }

    public int getServerVersion() throws SftpException {
        int r = this.myPeer.getServerVersion();
        LoggingSftpChannel.log("server version: {0}", r);
        return r;
    }

    public void setFilenameEncoding(String encoding) throws SftpException {
        LoggingSftpChannel.log("setFilenameEncoding(\"{0}\")", encoding);
        try {
            this.myPeer.setFilenameEncoding(encoding);
        }
        catch (SftpException e) {
            LOG.warn((Throwable)e);
            throw e;
        }
    }

    public String getExtension(String key) {
        String r = this.myPeer.getExtension(key);
        LoggingSftpChannel.log("getExtension(\"{0}\")=\"{1}\"", key, r);
        return r;
    }

    public String realpath(String path) throws SftpException {
        LoggingSftpChannel.log("realpath \"{0}\"", path);
        String r = this.myPeer.realpath(path);
        LoggingSftpChannel.log(r);
        return r;
    }

    public void setAgentForwarding(boolean enable) {
        LoggingSftpChannel.log("setAgentForwarding({0})", enable);
        this.myPeer.setAgentForwarding(enable);
    }

    public void setXForwarding(boolean enable) {
        LoggingSftpChannel.log("setXForwarding({0})", enable);
        this.myPeer.setXForwarding(enable);
    }

    public void setEnv(Hashtable env) {
        LoggingSftpChannel.log("setEnv({0})", env);
        this.myPeer.setEnv(env);
    }

    public void setEnv(String name, String value) {
        LoggingSftpChannel.log("setEnv(\"{0}\",\"{1}\")", name, value);
        this.myPeer.setEnv(name, value);
    }

    public void setEnv(byte[] name, byte[] value) {
        LoggingSftpChannel.log("setEnv(\"{0}\",\"{1}\")", name, value);
        this.myPeer.setEnv(name, value);
    }

    public void setPty(boolean enable) {
        LoggingSftpChannel.log("setPty({0})", enable);
        this.myPeer.setPty(enable);
    }

    public void setTerminalMode(byte[] terminal_mode) {
        LoggingSftpChannel.log("setTerminalMode(\"{0}\")", new Object[]{terminal_mode});
        this.myPeer.setTerminalMode(terminal_mode);
    }

    public void setPtySize(int col, int row, int wp, int hp) {
        LoggingSftpChannel.log("setPtySize({0},{1},{2},{3})", col, row, wp, hp);
        this.myPeer.setPtySize(col, row, wp, hp);
    }

    public void setPtyType(String ttype) {
        LoggingSftpChannel.log("setPtyType(\"{0}\")", ttype);
        this.myPeer.setPtyType(ttype);
    }

    public void setPtyType(String ttype, int col, int row, int wp, int hp) {
        LoggingSftpChannel.log("setPtyType(\"{0}\",{1},{2},{3},{4})", ttype, col, row, wp, hp);
        this.myPeer.setPtyType(ttype, col, row, wp, hp);
    }

    public void run() {
        LoggingSftpChannel.log("run()");
        this.myPeer.run();
    }

    public void connect() throws JSchException {
        LoggingSftpChannel.log("connect()");
        this.myPeer.connect();
    }

    public void connect(int connectTimeout) throws JSchException {
        LoggingSftpChannel.log("connect({0})", connectTimeout);
        this.myPeer.connect(connectTimeout);
    }

    public boolean isEOF() {
        boolean r = this.myPeer.isEOF();
        LoggingSftpChannel.log("eof: {0}", r);
        return r;
    }

    public void setInputStream(InputStream in) {
        LoggingSftpChannel.log("setInputStream(in)");
        this.myPeer.setInputStream(in);
    }

    public void setInputStream(InputStream in, boolean dontclose) {
        LoggingSftpChannel.log("setInputStream(in,{0})", dontclose);
        this.myPeer.setInputStream(in, dontclose);
    }

    public void setOutputStream(OutputStream out) {
        LoggingSftpChannel.log("setOutputStream(out)");
        this.myPeer.setOutputStream(out);
    }

    public void setOutputStream(OutputStream out, boolean dontclose) {
        LoggingSftpChannel.log("setOutputStream(out,{0})", dontclose);
        this.myPeer.setOutputStream(out, dontclose);
    }

    public void setExtOutputStream(OutputStream out) {
        LoggingSftpChannel.log("setExtOutputStream(out)");
        this.myPeer.setExtOutputStream(out);
    }

    public void setExtOutputStream(OutputStream out, boolean dontclose) {
        LoggingSftpChannel.log("setExtOutputStream(out,{0})", dontclose);
        this.myPeer.setExtOutputStream(out, dontclose);
    }

    public InputStream getInputStream() throws IOException {
        LoggingSftpChannel.log("getInputStream()");
        return this.myPeer.getInputStream();
    }

    public InputStream getExtInputStream() throws IOException {
        LoggingSftpChannel.log("getExtInputStream()");
        return this.myPeer.getExtInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        LoggingSftpChannel.log("getOutputStream()");
        return this.myPeer.getOutputStream();
    }

    public boolean isClosed() {
        boolean r = this.myPeer.isClosed();
        return r;
    }

    public boolean isConnected() {
        boolean r = this.myPeer.isConnected();
        return r;
    }

    public void sendSignal(String signal) throws Exception {
        LoggingSftpChannel.log("sendSignal \"{0}\"", signal);
        this.myPeer.sendSignal(signal);
    }

    public int getExitStatus() {
        int r = this.myPeer.getExitStatus();
        LoggingSftpChannel.log("getExitStatus()={0}", r);
        return r;
    }

    public Session getSession() throws JSchException {
        return this.myPeer.getSession();
    }

    public int getId() {
        int r = this.myPeer.getId();
        LoggingSftpChannel.log("getId()={0}", r);
        return r;
    }
}

