/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ide.diff.BackgroundOperatingDiffElement;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.ide.diff.VirtualFileDiffElement;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.SyncLocalVsRemoteAction;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.DiffRoot;
import com.jetbrains.plugins.webDeployment.ui.LocalItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteDiffElement;
import com.jetbrains.plugins.webDeployment.ui.RemoteItemDiffElement;
import com.jetbrains.plugins.webDeployment.ui.SyncUtils;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeDiffElement
extends DiffElement
implements BackgroundOperatingDiffElement {
    private static final Logger LOG = Logger.getInstance((String)CompositeDiffElement.class.getName());
    private final PublishConfig myConfig;
    private final Deployable myServer;
    private final DirDiffSettings myDiffSettings;
    private final List<DiffRoot> myDirectories;
    private final boolean myLocal;
    private DiffElement[] myChildren;
    @NotNull
    protected final Project myProject;
    protected final RemoteConnection myConnection;
    private boolean myContainsDirs;
    private boolean myContainsFiles;

    public static DiffElement createRootLocalDiffElement(@NotNull List<DiffRoot> files, @NotNull PublishConfig config, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project) throws FileSystemException {
        DiffRoot pair;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootLocalDiffElement"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootLocalDiffElement"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootLocalDiffElement"));
        }
        if (diffSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffSettings", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootLocalDiffElement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootLocalDiffElement"));
        }
        if (files.size() == 1 && (pair = files.get(0)).getLocal() != null && pair.getLocal().isDirectory() && pair.getRemote().exists()) {
            VirtualFile localItem = pair.getLocal();
            boolean excluded = SyncUtils.isExcludedLocalOrCorresponding(localItem.getPath(), pair.getMapping(), server, config, diffSettings);
            return new LocalItemDiffElement(localItem, pair.getMapping(), config, server, excluded, diffSettings, project, true);
        }
        try {
            return new LocalCompositeDiffElement(files, config, server, diffSettings, project);
        }
        catch (FileSystemException e) {
            LOG.error("No exceptions should occur here", (Throwable)e);
            return null;
        }
    }

    public static DiffElement createRootRemoteDiffElement(@NotNull List<DiffRoot> files, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project, @NotNull RemoteConnection connection) throws FileSystemException {
        DiffRoot pair;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootRemoteDiffElement"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootRemoteDiffElement"));
        }
        if (diffSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffSettings", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootRemoteDiffElement"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootRemoteDiffElement"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "createRootRemoteDiffElement"));
        }
        PublishConfig config = PublishConfig.getInstance(project);
        if (files.size() == 1 && (pair = files.get(0)).getLocal() != null && pair.getLocal().isDirectory() && pair.getRemote().exists()) {
            FileObject remoteItem = files.get(0).getRemote();
            boolean excluded = SyncUtils.isExcludedRemoteOrCorresponding(remoteItem, pair.getMapping(), server, config, diffSettings);
            return new RemoteItemDiffElement(connection, server, remoteItem, project, config, excluded, pair.getMapping(), diffSettings, true);
        }
        return new RemoteCompositeDiffElement(files, server, diffSettings, project, connection);
    }

    private CompositeDiffElement(@NotNull List<DiffRoot> directories, boolean local, @NotNull PublishConfig config, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project, @Nullable RemoteConnection connection) throws FileSystemException {
        if (directories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "<init>"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "<init>"));
        }
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "<init>"));
        }
        if (diffSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffSettings", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "<init>"));
        }
        this.myConfig = config;
        this.myServer = server;
        this.myDiffSettings = diffSettings;
        this.myProject = project;
        this.myConnection = connection;
        this.myDirectories = directories;
        this.myLocal = local;
        this.initializeChildren();
        this.initializeContainedTypes();
    }

    private void initializeChildren() throws FileSystemException {
        MultiMap defaultNames = new MultiMap();
        for (DiffRoot entry : this.myDirectories) {
            boolean bl = this.myLocal ? entry.getLocal() != null && entry.getLocal().exists() : entry.getRemote().exists();
            boolean add = bl;
            if (!add) continue;
            defaultNames.putValue((Object)this.getRootName(entry, false), (Object)entry);
        }
        Map<String, DiffRoot> namedRoots = this.makeRootNamesDifferent((MultiMap<String, DiffRoot>)defaultNames);
        ArrayList<BackgroundOperatingDiffElement> children = new ArrayList<BackgroundOperatingDiffElement>(this.myDirectories.size());
        for (Map.Entry<String, DiffRoot> entry : namedRoots.entrySet()) {
            DiffRoot diffRoot = entry.getValue();
            boolean excluded = this.myLocal ? SyncUtils.isExcludedLocalOrCorresponding(diffRoot.getLocal().getPath(), diffRoot.getMapping(), this.myServer, this.myConfig, this.myDiffSettings) : SyncUtils.isExcludedRemoteOrCorresponding(diffRoot.getRemote(), diffRoot.getMapping(), this.myServer, this.myConfig, this.myDiffSettings);
            BackgroundOperatingDiffElement element = this.myLocal ? new LocalItemDiffElement(diffRoot.getLocal(), diffRoot.getMapping(), this.myConfig, this.myServer, excluded, this.myDiffSettings, entry.getKey(), this.myProject, false) : new RemoteItemDiffElement(this.myConnection, this.myServer, diffRoot.getRemote(), this.myProject, this.myConfig, excluded, diffRoot.getMapping(), this.myDiffSettings, entry.getKey(), false);
            children.add(element);
        }
        this.myChildren = children.toArray(new DiffElement[children.size()]);
    }

    private Map<String, DiffRoot> makeRootNamesDifferent(MultiMap<String, DiffRoot> rootNames) {
        HashMap namedRoots = new HashMap();
        for (Map.Entry entry : rootNames.entrySet()) {
            if (((Collection)entry.getValue()).size() == 1) {
                namedRoots.put(entry.getKey(), ((Collection)entry.getValue()).iterator().next());
                continue;
            }
            for (DiffRoot root : (Collection)entry.getValue()) {
                namedRoots.put(this.getRootName(root, true), root);
            }
        }
        return namedRoots;
    }

    @NotNull
    private String getRootName(DiffRoot root, boolean forceLongName) {
        if (this.myLocal) {
            VirtualFile local = root.getLocal();
            if (forceLongName || local.isDirectory()) {
                String localPath = local.getPath();
                String string = CompositeDiffElement.getRelativePathOfProjectFileInProject(localPath, this.myProject);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRootName"));
                }
                return string;
            }
            String string = CompositeDiffElement.getSimpleRootName(local);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRootName"));
            }
            return string;
        }
        FileObject remote = root.getRemote();
        if (forceLongName || ServerTreeNode.getFileType(remote).hasChildren()) {
            String localPath = root.getMapping().mapToLocalPath(remote, (Mappable)this.myServer);
            localPath = FileUtil.toSystemIndependentName((String)localPath);
            String string = CompositeDiffElement.getRelativePathOfProjectFileInProject(localPath, this.myProject);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRootName"));
            }
            return string;
        }
        String string = CompositeDiffElement.getSimpleRootName(remote);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRootName"));
        }
        return string;
    }

    @NotNull
    public static String getSimpleRootName(VirtualFile local) {
        String string = local.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getSimpleRootName"));
        }
        return string;
    }

    public static String getSimpleRootName(FileObject remote) {
        return remote.getName().getBaseName();
    }

    @NotNull
    private static String getRelativePathOfProjectFileInProject(@NotNull String localPath, Project project) {
        VirtualFile[] contentRoots;
        String path;
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRelativePathOfProjectFileInProject"));
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir != null && (path = DeploymentPathUtils.getPathRemainder(baseDir.getPath(), localPath, SystemInfo.isFileSystemCaseSensitive)) != null) {
            if (path.isEmpty()) {
                String string = CompositeDiffElement.getDistinguishableFromContentRootPath(baseDir.getName(), localPath);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRelativePathOfProjectFileInProject"));
                }
                return string;
            }
            String string = CompositeDiffElement.getDistinguishableFromContentRootPath(path, localPath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRelativePathOfProjectFileInProject"));
            }
            return string;
        }
        for (VirtualFile root : contentRoots = ProjectRootManager.getInstance((Project)project).getContentRoots()) {
            path = DeploymentPathUtils.getPathRemainder(root.getPath(), localPath, SystemInfo.isFileSystemCaseSensitive);
            if (path == null) continue;
            String name = root.getName();
            for (VirtualFile contentRoot : contentRoots) {
                if (!name.equals(contentRoot.getName()) || contentRoot.equals(root)) continue;
                String string = localPath;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRelativePathOfProjectFileInProject"));
                }
                return string;
            }
            String string = path.isEmpty() ? WDBundle.message("0.in.angle.brackets", root.getName()) : WDBundle.message("path.in.root.0.1", root.getName(), path);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRelativePathOfProjectFileInProject"));
            }
            return string;
        }
        String string = localPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getRelativePathOfProjectFileInProject"));
        }
        return string;
    }

    @NotNull
    private static String getDistinguishableFromContentRootPath(@NotNull String shortenedPath, @NotNull String fullDefaultPath) {
        if (shortenedPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortenedPath", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getDistinguishableFromContentRootPath"));
        }
        if (fullDefaultPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullDefaultPath", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getDistinguishableFromContentRootPath"));
        }
        if (!shortenedPath.startsWith("<")) {
            String string = shortenedPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getDistinguishableFromContentRootPath"));
            }
            return string;
        }
        String string = fullDefaultPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getDistinguishableFromContentRootPath"));
        }
        return string;
    }

    private void initializeContainedTypes() throws FileSystemException {
        this.myContainsDirs = false;
        this.myContainsFiles = false;
        for (DiffRoot pair : this.myDirectories) {
            if (pair.getLocal() != null) {
                this.myContainsDirs |= pair.getLocal().isDirectory();
                this.myContainsFiles |= !pair.getLocal().isDirectory();
            } else {
                FileType fileType = pair.getRemote().getType();
                this.myContainsDirs |= fileType == FileType.FOLDER;
                this.myContainsFiles |= fileType == FileType.FILE;
            }
            if (!this.myContainsDirs || !this.myContainsFiles) continue;
            return;
        }
    }

    public String getPath() {
        if (this.myDirectories.size() == 1) {
            DiffRoot pair = this.myDirectories.get(0);
            if (this.myLocal) {
                if (pair.getLocal() != null) {
                    return pair.getLocal().getPresentableUrl();
                }
                return pair.getMapping().mapToLocalPath(pair.getRemote(), (Mappable)this.myServer);
            }
            return this.myServer.getPresentablePath(pair.getRemote());
        }
        int state = 0;
        state += this.myContainsDirs ? 1 : 0;
        return WDBundle.message("composite.diff.element.name", state += this.myContainsFiles ? 2 : 0, this.myLocal ? 1 : 0);
    }

    @NotNull
    public String getName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement", "getName"));
        }
        return "";
    }

    public long getSize() {
        return -1L;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public boolean isContainer() {
        return true;
    }

    public DiffElement[] getChildren() {
        if (!SyncLocalVsRemoteAction.isExcludedFileHidden(this.myDiffSettings)) {
            return this.myChildren;
        }
        ArrayList<DiffElement> elements = new ArrayList<DiffElement>();
        for (DiffElement element : this.myChildren) {
            if ((!(element instanceof LocalItemDiffElement) || ((LocalItemDiffElement)element).isExcluded()) && (!(element instanceof RemoteItemDiffElement) || ((RemoteItemDiffElement)element).isExcluded())) continue;
            elements.add(element);
        }
        return elements.toArray(new DiffElement[elements.size()]);
    }

    public byte[] getContent() {
        return null;
    }

    @Nullable
    public Object getValue() {
        return null;
    }

    public void refresh(boolean userInitiated) throws IOException {
        if (this.myLocal) {
            this.localRefreshFiles(userInitiated);
        } else {
            this.remoteRefreshFiles(userInitiated);
        }
        this.initializeChildren();
        this.initializeContainedTypes();
    }

    private void remoteRefreshFiles(boolean userInitiated) throws IOException {
        if (!userInitiated) {
            return;
        }
        for (DiffRoot pair : this.myDirectories) {
            final FileObject file = pair.getRemote();
            try {
                this.myConnection.executeServerOperation(new ThrowableRunnable<FileSystemException>(){

                    public void run() throws FileSystemException {
                        file.refresh();
                    }
                }, null);
            }
            catch (FileSystemException e) {
                LOG.warn((Throwable)e);
                throw new IOException(PublishUtils.getMessage(e, true), e);
            }
        }
    }

    private void localRefreshFiles(boolean userInitiated) {
        ArrayList<DiffRoot> freshDirectories = new ArrayList<DiffRoot>(this.myDirectories.size());
        for (DiffRoot diffRoot : this.myDirectories) {
            String localPath = diffRoot.getMapping().mapToLocalPath(diffRoot.getRemote(), (Mappable)this.myServer);
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(localPath);
            if (vFile != null) {
                VirtualFileDiffElement.refreshFile((boolean)userInitiated, (VirtualFile)vFile);
            }
            freshDirectories.add(DiffRoot.create(vFile, diffRoot.getRemote(), diffRoot.getMapping()));
        }
        this.myDirectories.clear();
        this.myDirectories.addAll(freshDirectories);
    }

    public String getPresentablePath() {
        if (this.myDirectories.size() == 1) {
            if (this.myLocal) {
                return this.getPath();
            }
            return WDBundle.message("remote.diff.title.0.on.server.1", this.myServer.getPresentablePath(this.myDirectories.get(0).getRemote()), this.myServer.getName());
        }
        int state = 0;
        state += this.myContainsDirs ? 1 : 0;
        return WDBundle.message("composite.diff.element.presentable.path", this.myLocal ? 1 : 0, state += this.myContainsFiles ? 2 : 0, this.myLocal ? "" : this.myServer.getName());
    }

    public boolean isOperationsEnabled() {
        return true;
    }

    public void copyTo(DiffElement container, Ref<String> errorMessage, Ref<DiffElement> diffElement, Runnable onFinish, DiffElement target, String relativePath) {
        throw new IllegalStateException("It's container diff element, and it shouldn't be copied itself.");
    }

    public void delete(Ref<String> errorMessage, Runnable onFinish) {
        throw new IllegalStateException("It's container diff element, and it shouldn't be deleted itself.");
    }

    public static class RemoteCompositeDiffElement
    extends CompositeDiffElement
    implements RemoteDiffElement {
        private RemoteCompositeDiffElement(@NotNull List<DiffRoot> directories, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project, @NotNull RemoteConnection connection) throws FileSystemException {
            if (directories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "<init>"));
            }
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "<init>"));
            }
            if (diffSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffSettings", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "<init>"));
            }
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "<init>"));
            }
            super(directories, false, PublishConfig.getInstance(project), server, diffSettings, project, connection);
        }

        @Override
        @NotNull
        public RemoteConnection getConnection() {
            RemoteConnection remoteConnection = this.myConnection;
            if (remoteConnection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "getConnection"));
            }
            return remoteConnection;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$RemoteCompositeDiffElement", "getProject"));
            }
            return project;
        }
    }

    public static class LocalCompositeDiffElement
    extends CompositeDiffElement {
        private LocalCompositeDiffElement(@NotNull List<DiffRoot> directories, @NotNull PublishConfig config, @NotNull Deployable server, @NotNull DirDiffSettings diffSettings, @NotNull Project project) throws FileSystemException {
            if (directories == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directories", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$LocalCompositeDiffElement", "<init>"));
            }
            if (config == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$LocalCompositeDiffElement", "<init>"));
            }
            if (server == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$LocalCompositeDiffElement", "<init>"));
            }
            if (diffSettings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffSettings", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$LocalCompositeDiffElement", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/ui/CompositeDiffElement$LocalCompositeDiffElement", "<init>"));
            }
            super(directories, true, config, server, diffSettings, project, null);
        }
    }
}

