/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.NamedItemsListEditor;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.remote.RemoteMappingsListener;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.AddServerDialog;
import com.jetbrains.plugins.webDeployment.ui.PublishOptionsConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableForm;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SharedDataHolder;
import gnu.trove.Equality;
import gnu.trove.THashMap;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentConfigurable
implements SearchableConfigurable,
Configurable.Composite,
Configurable.NoMargin,
Configurable.NoScroll,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)DeploymentConfigurable.class.getName());
    private final Project myProject;
    private int myTabIndex = -1;
    private final DeploymentConfigurableTabProvider[] myProviders;
    private final Map<DeploymentConfigurableTabProvider, SharedDataHolder> mySharedDataHolders;
    private MyNamedItemsListEditor myEditor;
    private Configurable[] myChildren;
    private boolean myIsFirstReset = true;

    public DeploymentConfigurable(@Nullable Project project) {
        this.myProject = project;
        this.myProviders = (DeploymentConfigurableTabProvider[])DeploymentConfigurableTabProvider.EP_NAME.getExtensions();
        THashMap sharedDataHolders = new THashMap(this.myProviders.length);
        for (DeploymentConfigurableTabProvider provider : this.myProviders) {
            sharedDataHolders.put(provider, new SharedDataHolder());
        }
        this.mySharedDataHolders = Collections.unmodifiableMap(sharedDataHolders);
    }

    private SharedDataHolder getHolder(DeploymentConfigurableTabProvider provider) {
        return this.mySharedDataHolders.get(provider);
    }

    private void createEditor() {
        Cloner<SettingsDeployable> cloner = new Cloner<SettingsDeployable>(){

            public SettingsDeployable cloneOf(SettingsDeployable item) {
                SettingsDeployable clone = item.clone();
                for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                    provider.copyData(DeploymentConfigurable.this.myProject, item, clone, DeploymentConfigurable.this.getHolder(provider));
                }
                return clone;
            }

            public SettingsDeployable copyOf(SettingsDeployable item) {
                SettingsDeployable copy = this.cloneOf(item);
                copy.setId(WebServerConfig.getNextId());
                DeploymentConfigurableForm f = (DeploymentConfigurableForm)DeploymentConfigurable.this.myEditor.getItemConfigurable(item);
                try {
                    f.applyTo(copy);
                }
                catch (ConfigurationException e) {
                    LOG.error((Throwable)e);
                }
                return copy;
            }
        };
        Equality<SettingsDeployable> comparer = new Equality<SettingsDeployable>(){

            public boolean equals(SettingsDeployable o1, SettingsDeployable o2) {
                if (!Comparing.equal((String)o1.getName(), (String)o2.getName())) {
                    return false;
                }
                for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                    if (provider.dataIsEqual(DeploymentConfigurable.this.myProject, o1, o2, DeploymentConfigurable.this.getHolder(provider))) continue;
                    return false;
                }
                return true;
            }
        };
        this.myEditor = new MyNamedItemsListEditor(cloner, comparer, new NodeComparator(this.myProject), new WebServerConfigNamer());
        this.myEditor.setShowIcons(true);
    }

    @Nls
    public String getDisplayName() {
        return WDBundle.message("deployment.configurable.name", new Object[0]);
    }

    public static void show(@Nullable WebServerConfig server, boolean newServer, @Nullable Project project, int tabIndex) {
        DeploymentConfigurable configurable = new DeploymentConfigurable(project);
        SettingsDeployable settingsDeployable = SettingsDeployable.create(server);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable, () -> {
            SettingsDeployable selection;
            if (newServer) {
                configurable.myEditor.onItemCreated(settingsDeployable);
                configurable.myEditor.getToolbar().dispatchEvent(new KeyEvent(configurable.myEditor.getToolbar(), 401, System.currentTimeMillis(), 0, 32, ' '));
            }
            if ((selection = settingsDeployable) == null && project != null) {
                WebServerConfig defaultServer = PublishConfig.getInstance(project).findDefaultServer();
                selection = SettingsDeployable.create(defaultServer);
            }
            if (selection != null) {
                configurable.myEditor.selectItem(selection);
                if (tabIndex != -1) {
                    DeploymentConfigurableForm f = (DeploymentConfigurableForm)configurable.myEditor.getItemConfigurable((SettingsDeployable)configurable.myEditor.getSelectedItem());
                    f.setSelectedTabIndex(tabIndex);
                }
            }
        });
    }

    @NotNull
    public String getId() {
        if ("web.server" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurable", "getId"));
        }
        return "web.server";
    }

    public String getHelpTopic() {
        return "reference.settings.deployment";
    }

    public JComponent createComponent() {
        if (this.myEditor == null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

                @Override
                public void deploymentConfigChanged() {
                    DeploymentConfigurable.this.reset();
                }

                @Override
                public void optionsChanged() {
                }

                @Override
                public void excludedPathsChanged() {
                }
            });
            this.createEditor();
        }
        return this.myEditor.createComponent();
    }

    public boolean isModified() {
        for (DeploymentConfigurableTabProvider provider : this.myProviders) {
            if (!provider.isNonServerDataModified(this.myProject, this.getHolder(provider))) continue;
            return true;
        }
        return this.myEditor.isModified();
    }

    public void reset() {
        this.myEditor.reset();
        if (this.myIsFirstReset && this.myProject != null) {
            this.myIsFirstReset = false;
            WebServerConfig defaultServer = PublishConfig.getInstance(this.myProject).findDefaultServer();
            if (defaultServer != null) {
                SettingsDeployable defaultSettingsDeployable = SettingsDeployable.create(defaultServer);
                this.myEditor.selectItem(defaultSettingsDeployable);
            }
        }
    }

    public void apply() throws ConfigurationException {
        this.myEditor.apply();
        ((RemoteMappingsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(RemoteMappingsListener.REMOTE_MAPPINGS_CHANGED)).mappingsChanged();
    }

    public void disposeUIResources() {
        this.myIsFirstReset = true;
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
        }
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    public Configurable[] getConfigurables() {
        if (this.myChildren == null) {
            Configurable[] configurableArray;
            if (this.myProject != null) {
                Configurable[] configurableArray2 = new Configurable[1];
                configurableArray = configurableArray2;
                configurableArray2[0] = new PublishOptionsConfigurable(this.myProject);
            } else {
                configurableArray = new Configurable[]{};
            }
            this.myChildren = configurableArray;
        }
        return this.myChildren;
    }

    @NotNull
    private static List<SettingsDeployable> getServersWithCredentials(Project project) {
        List<WebServerConfig> servers = WebServersConfigManager.getInstance(project).getServers(false);
        MyWrappingList myWrappingList = new MyWrappingList(servers);
        if (myWrappingList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurable", "getServersWithCredentials"));
        }
        return myWrappingList;
    }

    public static <E> Map<String, E> filterExistingServers(Map<String, E> elements, List<SettingsDeployable> currentServers) {
        HashMap<String, E> result = new HashMap<String, E>();
        for (SettingsDeployable server : currentServers) {
            String id = server.getId();
            E e = elements.get(id);
            if (e == null) continue;
            result.put(id, e);
        }
        return result;
    }

    private static class NodeComparator
    implements Comparator<MasterDetailsComponent.MyNode> {
        private final PublishConfig myConfig;

        private NodeComparator(@Nullable Project project) {
            this.myConfig = project == null ? null : PublishConfig.getInstance(project);
        }

        @Override
        public int compare(MasterDetailsComponent.MyNode o1, MasterDetailsComponent.MyNode o2) {
            SettingsDeployable server2;
            Object object1 = o1.getConfigurable().getEditableObject();
            Object object2 = o2.getConfigurable().getEditableObject();
            SettingsDeployable server1 = object1 instanceof SettingsDeployable ? (SettingsDeployable)object1 : null;
            SettingsDeployable settingsDeployable = server2 = object2 instanceof SettingsDeployable ? (SettingsDeployable)object2 : null;
            if (server1 == null && server2 == null) {
                return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
            }
            if (server1 == null) {
                return 1;
            }
            if (server2 == null) {
                return -1;
            }
            if (this.myConfig != null) {
                return server1.compareTo(server2, this.myConfig);
            }
            return server1.getName().compareTo(server2.getName());
        }
    }

    private class WebServerConfigNamer
    implements Namer<SettingsDeployable> {
        private WebServerConfigNamer() {
        }

        public String getName(SettingsDeployable item) {
            return item.getName();
        }

        public boolean canRename(SettingsDeployable item) {
            return true;
        }

        public void setName(SettingsDeployable item, String name) {
            item.setName(name);
            DeploymentConfigurableForm f = (DeploymentConfigurableForm)DeploymentConfigurable.this.myEditor.getItemConfigurable(item);
            if (f != null) {
                f.fireChanged();
            }
        }
    }

    private class MyNamedItemsListEditor
    extends NamedItemsListEditor<SettingsDeployable> {
        private final Comparator<MasterDetailsComponent.MyNode> myComparator;

        public MyNamedItemsListEditor(Cloner<SettingsDeployable> cloner, Equality<SettingsDeployable> comparer, NodeComparator comparator, WebServerConfigNamer namer) {
            super((Namer)namer, null, cloner, comparer, DeploymentConfigurable.getServersWithCredentials(DeploymentConfigurable.this.myProject));
            this.myComparator = comparator;
            this.getTree().getEmptyText().setText(WDBundle.message("deployment.not.configured", new Object[0]));
        }

        protected UnnamedConfigurable createConfigurable(final SettingsDeployable item) {
            return new DeploymentConfigurableForm(item, DeploymentConfigurable.this.myProject){

                @Override
                protected void setUpComponent() {
                    ArrayList<DeploymentConfigurableTab> tabs = new ArrayList<DeploymentConfigurableTab>();
                    for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                        DeploymentConfigurableTab tab = provider.createTab(DeploymentConfigurable.this.myProject, this, DeploymentConfigurable.this.getHolder(provider));
                        if (tab == null) continue;
                        tabs.add(tab);
                    }
                    Collections.sort(tabs, Comparator.comparingInt(DeploymentConfigurableTab::getWeight));
                    for (DeploymentConfigurableTab tab : tabs) {
                        this.addTab(tab);
                    }
                    this.addTabChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            DeploymentConfigurable.this.myTabIndex = this.getSelectedTabIndex();
                        }
                    });
                    if (DeploymentConfigurable.this.myTabIndex != -1) {
                        this.setSelectedTabIndex(DeploymentConfigurable.this.myTabIndex);
                    }
                    this.addItemPresentationChangeListener(new DeploymentConfigurableTab.ItemPresentationChangeListener(){

                        @Override
                        public void presentationChanged(@Nullable Boolean isBold) {
                            MasterDetailsComponent.MyNode n = MasterDetailsComponent.findNodeByObject((TreeNode)MyNamedItemsListEditor.this.myRoot, (Object)item);
                            if (n != null && n.getConfigurable() != null) {
                                if (isBold != null) {
                                    n.setDisplayInBold(isBold.booleanValue());
                                }
                                MyNamedItemsListEditor.this.runUpdater();
                            }
                        }
                    }, this);
                    this.addListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent e) {
                            MyNamedItemsListEditor.this.runUpdater();
                        }
                    }, this);
                    this.reset();
                }
            };
        }

        @Nls
        public String getDisplayName() {
            return WDBundle.message("deployment.configurable.name", new Object[0]);
        }

        public void apply() throws ConfigurationException {
            super.apply();
            List serversWithCredentials = this.getItems();
            ArrayList<WebServerConfig> servers = new ArrayList<WebServerConfig>(serversWithCredentials.size());
            for (SettingsDeployable credential : serversWithCredentials) {
                servers.add(credential.computeWebServerConfig());
            }
            WebServerConfig.fixDuplicatingNames(servers);
            WebServersConfigManager.getInstance(DeploymentConfigurable.this.myProject).setServers(servers);
            for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                provider.apply(DeploymentConfigurable.this.myProject, serversWithCredentials, DeploymentConfigurable.this.getHolder(provider));
            }
            ((DeploymentConfigChangeListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).deploymentConfigChanged();
            this.reset();
        }

        public void reset() {
            for (SettingsDeployable item : this.getCurrentItems()) {
                UnnamedConfigurable c = this.getItemConfigurable(item);
                if (c == null) continue;
                c.disposeUIResources();
            }
            for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                provider.reset(DeploymentConfigurable.this.myProject, DeploymentConfigurable.this.getHolder(provider));
            }
            super.reset();
        }

        protected String subjDisplayName() {
            return WDBundle.message("web.server", new Object[0]);
        }

        public SettingsDeployable createItem() {
            WebServerConfig webServerConfig = new AddServerDialog((Component)this.myTree, false, DeploymentConfigurable.this.myProject).showAndReturnResult();
            return SettingsDeployable.create(webServerConfig);
        }

        protected String getEmptySelectionString() {
            return this.getCurrentItems().isEmpty() ? WDBundle.message("deployment.config.welcome.message", new Object[0]) : WDBundle.message("deployment.config.unselected.message", new Object[0]);
        }

        public void selectItem(SettingsDeployable item) {
            for (SettingsDeployable server : this.getCurrentItems()) {
                if (!server.getId().equals(item.getId())) continue;
                this.selectNodeInTree(item);
                return;
            }
        }

        public void onItemCreated(SettingsDeployable newItem) {
            List items = this.getCurrentItems();
            for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                provider.onItemCreated(DeploymentConfigurable.this.myProject, newItem, items, DeploymentConfigurable.this.getHolder(provider));
            }
            DeploymentConfigurable.this.myTabIndex = 0;
            super.onItemCreated((Object)newItem);
        }

        protected void onItemDeleted(Object item) {
            UnnamedConfigurable c = this.getItemConfigurable((SettingsDeployable)item);
            if (c != null) {
                c.disposeUIResources();
            }
            super.onItemDeleted(item);
            List items = this.getCurrentItems();
            for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                provider.onItemDeleted(DeploymentConfigurable.this.myProject, (SettingsDeployable)item, items, DeploymentConfigurable.this.getHolder(provider));
            }
        }

        protected ArrayList<AnAction> createActions(boolean fromPopup) {
            ArrayList result = super.createActions(fromPopup);
            for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                provider.createActions(fromPopup, DeploymentConfigurable.this.myProject, result, (Computable<SettingsDeployable>)((Computable)() -> (SettingsDeployable)this.getSelectedItem()), this.TREE_UPDATER, DeploymentConfigurable.this.getHolder(provider));
            }
            return result;
        }

        protected void updateSelection(@Nullable NamedConfigurable configurable) {
            if (configurable != null) {
                DeploymentConfigurableForm f = (DeploymentConfigurableForm)this.getItemConfigurable((SettingsDeployable)configurable.getEditableObject());
                LOG.assertTrue(f != null);
                if (DeploymentConfigurable.this.myTabIndex != -1) {
                    f.setSelectedTabIndex(DeploymentConfigurable.this.myTabIndex);
                }
            }
            super.updateSelection(configurable);
        }

        protected void addNode(MasterDetailsComponent.MyNode nodeToAdd, MasterDetailsComponent.MyNode parent) {
            SettingsDeployable item = (SettingsDeployable)nodeToAdd.getConfigurable().getEditableObject();
            for (DeploymentConfigurableTabProvider provider : DeploymentConfigurable.this.myProviders) {
                if (!provider.isDisplayInBold(DeploymentConfigurable.this.myProject, item, DeploymentConfigurable.this.getHolder(provider))) continue;
                nodeToAdd.setDisplayInBold(true);
                break;
            }
            super.addNode(nodeToAdd, parent);
        }

        public UnnamedConfigurable getItemConfigurable(SettingsDeployable item) {
            return super.getItemConfigurable((Object)item);
        }

        protected void runUpdater() {
            MasterDetailsComponent.MyNode node;
            if (this.myTree.getSelectionPath() != null && (node = (MasterDetailsComponent.MyNode)this.myTree.getSelectionPath().getLastPathComponent()) != null && node.getConfigurable() != null) {
                this.TREE_UPDATER.run();
            }
        }

        protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
            return this.myComparator == null ? super.getNodeComparator() : this.myComparator;
        }
    }

    private static class MyWrappingList
    extends AbstractList<SettingsDeployable> {
        @NotNull
        private final List<WebServerConfig> myList;
        private final Map<WebServerConfig, SettingsDeployable> myWraps;

        public MyWrappingList(@NotNull List<WebServerConfig> list) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/plugins/webDeployment/ui/config/DeploymentConfigurable$MyWrappingList", "<init>"));
            }
            this.myWraps = new com.intellij.util.containers.hash.HashMap();
            this.myList = list;
        }

        @Override
        public SettingsDeployable get(int index) {
            WebServerConfig serverConfig = this.myList.get(index);
            SettingsDeployable settingsDeployable = this.myWraps.get(serverConfig);
            if (settingsDeployable == null) {
                settingsDeployable = SettingsDeployable.create(serverConfig);
                this.myWraps.put(serverConfig, settingsDeployable);
            }
            return settingsDeployable;
        }

        @Override
        public int size() {
            return this.myList.size();
        }
    }
}

