/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesPreprocess;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.ExternallyRenamedChange;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.versionBrowser.VcsRevisionNumberAware;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.browse.DirectoryEntry;
import org.jetbrains.idea.svn.browse.DirectoryEntryConsumer;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.SvnLazyPropertyContentRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.jetbrains.idea.svn.info.Info;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnChangeList
implements CommittedChangeList,
VcsRevisionNumberAware {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.svn.history");
    private final SvnVcs myVcs;
    private final SvnRepositoryLocation myLocation;
    private String myRepositoryRoot;
    private long myRevision;
    private VcsRevisionNumber myRevisionNumber;
    private String myAuthor;
    private Date myDate;
    private String myMessage;
    private final Set<String> myChangedPaths;
    private final Set<String> myAddedPaths;
    private final Set<String> myDeletedPaths;
    private final Set<String> myReplacedPaths;
    private ChangesListCreationHelper myListsHolder;
    private SVNURL myBranchUrl;
    private boolean myCachedInfoLoaded;
    private final TreeMap<String, String> myCopiedAddedPaths;
    private RootUrlInfo myWcRoot;
    private final CommonPathSearcher myCommonPathSearcher;
    private final Set<String> myKnownAsDirectories;

    public SvnChangeList(@NotNull List<CommittedChangeList> lists, @NotNull SvnRepositoryLocation location) {
        if (lists == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lists", "org/jetbrains/idea/svn/history/SvnChangeList", "<init>"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnChangeList", "<init>"));
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new TreeMap();
        SvnChangeList sample = (SvnChangeList)lists.get(0);
        this.myVcs = sample.myVcs;
        this.myLocation = location;
        this.setRevision(sample.myRevision);
        this.myAuthor = sample.myAuthor;
        this.myDate = sample.myDate;
        this.myMessage = sample.myMessage;
        this.myRepositoryRoot = sample.myRepositoryRoot;
        this.myCommonPathSearcher = new CommonPathSearcher();
        for (CommittedChangeList list : lists) {
            SvnChangeList svnList = (SvnChangeList)list;
            this.myChangedPaths.addAll(svnList.myChangedPaths);
            this.myAddedPaths.addAll(svnList.myAddedPaths);
            this.myDeletedPaths.addAll(svnList.myDeletedPaths);
            this.myReplacedPaths.addAll(svnList.myReplacedPaths);
        }
        this.myKnownAsDirectories = new HashSet<String>(0);
    }

    public SvnChangeList(SvnVcs vcs, @NotNull SvnRepositoryLocation location, LogEntry logEntry, String repositoryRoot) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnChangeList", "<init>"));
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new TreeMap();
        this.myVcs = vcs;
        this.myLocation = location;
        this.setRevision(logEntry.getRevision());
        this.myAuthor = StringUtil.notNullize((String)logEntry.getAuthor());
        this.myDate = logEntry.getDate();
        this.myMessage = StringUtil.notNullize((String)logEntry.getMessage());
        this.myRepositoryRoot = UriUtil.trimTrailingSlashes((String)repositoryRoot);
        this.myCommonPathSearcher = new CommonPathSearcher();
        this.myKnownAsDirectories = new HashSet<String>(0);
        for (LogEntryPath entry : logEntry.getChangedPaths().values()) {
            String path = entry.getPath();
            if (entry.isDirectory()) {
                this.myKnownAsDirectories.add(path);
            }
            this.myCommonPathSearcher.next(path);
            if (entry.getType() == 'A') {
                if (entry.getCopyPath() != null) {
                    this.myCopiedAddedPaths.put(path, entry.getCopyPath());
                }
                this.myAddedPaths.add(path);
                continue;
            }
            if (entry.getType() == 'D') {
                this.myDeletedPaths.add(path);
                continue;
            }
            if (entry.getType() == 'R') {
                this.myReplacedPaths.add(path);
            }
            this.myChangedPaths.add(path);
        }
    }

    public SvnChangeList(SvnVcs vcs, @NotNull SvnRepositoryLocation location, @NotNull DataInput stream, boolean supportsCopyFromInfo, boolean supportsReplaced) throws IOException {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/idea/svn/history/SvnChangeList", "<init>"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/idea/svn/history/SvnChangeList", "<init>"));
        }
        this.myChangedPaths = new HashSet<String>();
        this.myAddedPaths = new HashSet<String>();
        this.myDeletedPaths = new HashSet<String>();
        this.myReplacedPaths = new HashSet<String>();
        this.myCopiedAddedPaths = new TreeMap();
        this.myVcs = vcs;
        this.myLocation = location;
        this.myKnownAsDirectories = new HashSet<String>();
        this.readFromStream(stream, supportsCopyFromInfo, supportsReplaced);
        this.myCommonPathSearcher = new CommonPathSearcher();
        this.myCommonPathSearcher.next(this.myAddedPaths);
        this.myCommonPathSearcher.next(this.myDeletedPaths);
        this.myCommonPathSearcher.next(this.myChangedPaths);
    }

    public Change getByPath(String path) {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getByPath(path);
    }

    public String getCommitterName() {
        return this.myAuthor;
    }

    @Nullable
    public Date getCommitDate() {
        return this.myDate;
    }

    @Nullable
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevisionNumber;
    }

    private void setRevision(long revision) {
        this.myRevision = revision;
        this.myRevisionNumber = new SvnRevisionNumber(SVNRevision.create((long)revision));
    }

    public Collection<Change> getChanges() {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getList();
    }

    private void createLists() {
        this.myListsHolder = new ChangesListCreationHelper();
        HashMap<String, ExternallyRenamedChange> copiedAddedChanges = new HashMap<String, ExternallyRenamedChange>();
        this.correctBeforePaths();
        ArrayList<String> copyDeleted = new ArrayList<String>(this.myDeletedPaths);
        for (String path : this.myAddedPaths) {
            Change addedChange;
            if (this.myCopiedAddedPaths.containsKey(path)) {
                String copyTarget = this.myCopiedAddedPaths.get(path);
                if (copyDeleted.contains(copyTarget)) {
                    addedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(copyTarget, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyTarget);
                    addedChange.getMoveRelativePath(this.myVcs.getProject());
                    ((ExternallyRenamedChange)addedChange).setCopied(false);
                    copyDeleted.remove(copyTarget);
                } else {
                    addedChange = new ExternallyRenamedChange(null, (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyTarget);
                }
                copiedAddedChanges.put(copyTarget, (ExternallyRenamedChange)addedChange);
            } else {
                addedChange = new Change(null, (ContentRevision)this.myListsHolder.createRevisionLazily(path, false));
            }
            this.myListsHolder.add(path, addedChange);
        }
        for (String path : copyDeleted) {
            Change deletedChange;
            if (copiedAddedChanges.containsKey(path)) {
                ExternallyRenamedChange addedChange = (ExternallyRenamedChange)copiedAddedChanges.get(path);
                FilePath source = addedChange.getAfterRevision().getFile();
                deletedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createDeletedItemRevision(path, true), null, path);
                ((ExternallyRenamedChange)deletedChange).setCopied(false);
                ((ExternallyRenamedChange)deletedChange).setRenamedOrMovedTarget(source);
            } else {
                deletedChange = new Change((ContentRevision)this.myListsHolder.createDeletedItemRevision(path, true), null);
            }
            this.myListsHolder.add(path, deletedChange);
        }
        for (String path : this.myChangedPaths) {
            boolean moveAndChange = false;
            boolean replaced = this.myReplacedPaths.contains(path);
            for (String addedPath : this.myAddedPaths) {
                String copyFromPath = this.myCopiedAddedPaths.get(addedPath);
                if (copyFromPath == null || !SVNPathUtil.isAncestor((String)addedPath, (String)path)) continue;
                if (addedPath.length() < path.length()) {
                    String relative = SVNPathUtil.getRelativePath((String)addedPath, (String)path);
                    copyFromPath = SVNPathUtil.append((String)copyFromPath, (String)relative);
                }
                ExternallyRenamedChange renamedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(copyFromPath, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), copyFromPath);
                moveAndChange = true;
                renamedChange.getMoveRelativePath(this.myVcs.getProject());
                renamedChange.setIsReplaced(replaced);
                ExternallyRenamedChange addedChange = (ExternallyRenamedChange)copiedAddedChanges.get(this.myCopiedAddedPaths.get(addedPath));
                renamedChange.setCopied(addedChange != null && addedChange.isCopied());
                this.myListsHolder.add(path, (Change)renamedChange);
                break;
            }
            if (moveAndChange) continue;
            ExternallyRenamedChange renamedChange = new ExternallyRenamedChange((ContentRevision)this.myListsHolder.createRevisionLazily(path, true), (ContentRevision)this.myListsHolder.createRevisionLazily(path, false), null);
            renamedChange.setIsReplaced(replaced);
            renamedChange.setCopied(false);
            this.myListsHolder.add(path, (Change)renamedChange);
        }
    }

    private void correctBeforePaths() {
        this.processDeletedForBeforePaths(this.myDeletedPaths);
        this.processModifiedForBeforePaths(this.myChangedPaths);
        this.processModifiedForBeforePaths(this.myReplacedPaths);
    }

    private void processModifiedForBeforePaths(Set<String> paths) {
        RenameHelper helper = new RenameHelper();
        for (String s : paths) {
            String converted;
            if (s.equals(converted = helper.convertBeforePath(s, this.myCopiedAddedPaths))) continue;
            this.myCopiedAddedPaths.put(s, converted);
        }
    }

    private void processDeletedForBeforePaths(Set<String> paths) {
        RenameHelper helper = new RenameHelper();
        HashSet<String> copy = new HashSet<String>(paths);
        paths.clear();
        for (String s : copy) {
            paths.add(helper.convertBeforePath(s, this.myCopiedAddedPaths));
        }
    }

    @Nullable
    private FilePath getLocalPath(String path, NotNullFunction<File, Boolean> detector) {
        return SvnRepositoryLocation.getLocalPath(this.myRepositoryRoot + path, detector, this.myVcs);
    }

    private long getRevision(boolean isBeforeRevision) {
        return isBeforeRevision ? this.myRevision - 1L : this.myRevision;
    }

    public SvnRepositoryLocation getLocation() {
        return this.myLocation;
    }

    private void patchChange(Change change, String path) {
        SVNURL wasUrl;
        SVNURL becameUrl;
        try {
            String originUrl;
            wasUrl = becameUrl = SVNURL.parseURIEncoded((String)SVNPathUtil.append((String)this.myRepositoryRoot, (String)path));
            if (change instanceof ExternallyRenamedChange && change.getBeforeRevision() != null && (originUrl = ((ExternallyRenamedChange)change).getOriginUrl()) != null) {
                wasUrl = SVNURL.parseURIEncoded((String)SVNPathUtil.append((String)this.myRepositoryRoot, (String)originUrl));
            }
        }
        catch (SVNException e) {
            LOG.info((Throwable)e);
            return;
        }
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        Change additional = new Change((ContentRevision)this.createPropertyRevision(filePath, change.getBeforeRevision(), wasUrl), (ContentRevision)this.createPropertyRevision(filePath, change.getAfterRevision(), becameUrl));
        change.addAdditionalLayerElement("Property", additional);
    }

    @Nullable
    private SvnLazyPropertyContentRevision createPropertyRevision(@NotNull FilePath filePath, @Nullable ContentRevision revision, @NotNull SVNURL url) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "org/jetbrains/idea/svn/history/SvnChangeList", "createPropertyRevision"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/history/SvnChangeList", "createPropertyRevision"));
        }
        return revision == null ? null : new SvnLazyPropertyContentRevision(this.myVcs, filePath, revision.getRevisionNumber(), url);
    }

    @NotNull
    public String getName() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnChangeList", "getName"));
        }
        return string;
    }

    public String getComment() {
        return this.myMessage;
    }

    public long getNumber() {
        return this.myRevision;
    }

    public String getBranch() {
        return null;
    }

    public AbstractVcs getVcs() {
        return this.myVcs;
    }

    public Collection<Change> getChangesWithMovedTrees() {
        if (this.myListsHolder == null) {
            this.createLists();
        }
        return this.myListsHolder.getDetailedList();
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String newMessage) {
        this.myMessage = newMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SvnChangeList that = (SvnChangeList)o;
        if (this.myRevision != that.myRevision) {
            return false;
        }
        if (this.myAuthor != null ? !this.myAuthor.equals(that.myAuthor) : that.myAuthor != null) {
            return false;
        }
        if (this.myDate != null ? !this.myDate.equals(that.myDate) : that.myDate != null) {
            return false;
        }
        return !(this.myMessage != null ? !this.myMessage.equals(that.myMessage) : that.myMessage != null);
    }

    public int hashCode() {
        int result = (int)(this.myRevision ^ this.myRevision >>> 32);
        result = 31 * result + (this.myAuthor != null ? this.myAuthor.hashCode() : 0);
        result = 31 * result + (this.myDate != null ? this.myDate.hashCode() : 0);
        result = 31 * result + (this.myMessage != null ? this.myMessage.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myMessage;
    }

    public void writeToStream(@NotNull DataOutput stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/idea/svn/history/SvnChangeList", "writeToStream"));
        }
        stream.writeUTF(this.myRepositoryRoot);
        stream.writeLong(this.myRevision);
        stream.writeUTF(this.myAuthor);
        stream.writeLong(this.myDate.getTime());
        SvnChangeList.writeUTFTruncated(stream, this.myMessage);
        SvnChangeList.writeFiles(stream, this.myChangedPaths);
        SvnChangeList.writeFiles(stream, this.myAddedPaths);
        SvnChangeList.writeFiles(stream, this.myDeletedPaths);
        SvnChangeList.writeMap(stream, this.myCopiedAddedPaths);
        SvnChangeList.writeFiles(stream, this.myReplacedPaths);
        stream.writeInt(this.myKnownAsDirectories.size());
        for (String directory : this.myKnownAsDirectories) {
            stream.writeUTF(directory);
        }
    }

    public static void writeUTFTruncated(DataOutput stream, String text) throws IOException {
        if (text.length() > 16383) {
            stream.writeUTF(text.substring(0, 16383));
        } else {
            stream.writeUTF(text);
        }
    }

    private static void writeFiles(DataOutput stream, Set<String> paths) throws IOException {
        stream.writeInt(paths.size());
        for (String s : paths) {
            stream.writeUTF(s);
        }
    }

    private void readFromStream(@NotNull DataInput stream, boolean supportsCopyFromInfo, boolean supportsReplaced) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "org/jetbrains/idea/svn/history/SvnChangeList", "readFromStream"));
        }
        this.myRepositoryRoot = stream.readUTF();
        this.setRevision(stream.readLong());
        this.myAuthor = stream.readUTF();
        this.myDate = new Date(stream.readLong());
        this.myMessage = stream.readUTF();
        SvnChangeList.readFiles(stream, this.myChangedPaths);
        SvnChangeList.readFiles(stream, this.myAddedPaths);
        SvnChangeList.readFiles(stream, this.myDeletedPaths);
        if (supportsCopyFromInfo) {
            SvnChangeList.readMap(stream, this.myCopiedAddedPaths);
        }
        if (supportsReplaced) {
            SvnChangeList.readFiles(stream, this.myReplacedPaths);
        }
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            this.myKnownAsDirectories.add(stream.readUTF());
        }
    }

    private static void writeMap(DataOutput stream, Map<String, String> map) throws IOException {
        stream.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stream.writeUTF(entry.getKey());
            stream.writeUTF(entry.getValue());
        }
    }

    private static void readMap(DataInput stream, Map<String, String> map) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            map.put(stream.readUTF(), stream.readUTF());
        }
    }

    private static void readFiles(DataInput stream, Set<String> paths) throws IOException {
        int count = stream.readInt();
        for (int i = 0; i < count; ++i) {
            paths.add(stream.readUTF());
        }
    }

    public SVNURL getBranchUrl() {
        this.ensureCacheUpdated();
        return this.myBranchUrl;
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        this.ensureCacheUpdated();
        return this.myWcRoot == null ? null : this.myWcRoot.getRoot();
    }

    @Nullable
    public VirtualFile getRoot() {
        this.ensureCacheUpdated();
        return this.myWcRoot == null ? null : this.myWcRoot.getVirtualFile();
    }

    public RootUrlInfo getWcRootInfo() {
        this.ensureCacheUpdated();
        return this.myWcRoot;
    }

    private void ensureCacheUpdated() {
        if (!this.myCachedInfoLoaded) {
            this.updateCachedInfo();
        }
    }

    private void updateCachedInfo() {
        this.myCachedInfoLoaded = true;
        String commonPath = this.myCommonPathSearcher.getCommon();
        if (commonPath != null) {
            SvnFileUrlMapping urlMapping = this.myVcs.getSvnFileUrlMapping();
            if (urlMapping.isEmpty()) {
                this.myCachedInfoLoaded = false;
                return;
            }
            String absoluteUrl = SVNPathUtil.append((String)this.myRepositoryRoot, (String)commonPath);
            this.myWcRoot = urlMapping.getWcRootForUrl(absoluteUrl);
            if (this.myWcRoot != null) {
                this.myBranchUrl = SvnUtil.getBranchForUrl(this.myVcs, this.myWcRoot.getVirtualFile(), absoluteUrl);
            }
        }
    }

    public void forceReloadCachedInfo() {
        this.myCachedInfoLoaded = false;
        this.myBranchUrl = null;
        this.myWcRoot = null;
    }

    @NotNull
    public Set<String> getAffectedPaths() {
        HashSet hashSet = ContainerUtil.newHashSet((Iterable)ContainerUtil.concat((Iterable[])new Iterable[]{this.myAddedPaths, this.myDeletedPaths, this.myChangedPaths}));
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnChangeList", "getAffectedPaths"));
        }
        return hashSet;
    }

    @Nullable
    public String getWcPath() {
        RootUrlInfo rootInfo = this.getWcRootInfo();
        return rootInfo == null ? null : rootInfo.getIoFile().getAbsolutePath();
    }

    public boolean allPathsUnder(String path) {
        String commonRelative = this.myCommonPathSearcher.getCommon();
        return commonRelative != null && SVNPathUtil.isAncestor((String)path, (String)SVNPathUtil.append((String)this.myRepositoryRoot, (String)commonRelative));
    }

    private static class CommonPathSearcher {
        private String myCommon;

        private CommonPathSearcher() {
        }

        public void next(Iterable<String> values) {
            for (String value : values) {
                this.next(value);
            }
        }

        public void next(String value) {
            if (value == null) {
                return;
            }
            if (this.myCommon == null) {
                this.myCommon = value;
                return;
            }
            if (value.startsWith(this.myCommon)) {
                return;
            }
            this.myCommon = SVNPathUtil.getCommonPathAncestor((String)this.myCommon, (String)value);
        }

        public String getCommon() {
            return this.myCommon;
        }
    }

    private static class RenameHelper {
        private RenameHelper() {
        }

        public String convertBeforePath(String path, TreeMap<String, String> after2before) {
            String current = path;
            for (String key : after2before.descendingKeySet()) {
                if (!SVNPathUtil.isAncestor((String)key, (String)current)) continue;
                String relativePath = SVNPathUtil.getRelativePath((String)key, (String)current);
                current = SVNPathUtil.append((String)after2before.get(key), (String)relativePath);
            }
            return current;
        }
    }

    private class ChangesListCreationHelper {
        private final List<Change> myList = new ArrayList<Change>();
        private final Map<String, Change> myPathToChangeMapping;
        private List<Change> myDetailedList;
        private final List<Pair<Integer, Boolean>> myWithoutDirStatus = new ArrayList<Pair<Integer, Boolean>>();

        private ChangesListCreationHelper() {
            this.myPathToChangeMapping = new HashMap<String, Change>();
        }

        public void add(String path, Change change) {
            SvnChangeList.this.patchChange(change, path);
            this.myList.add(change);
            this.myPathToChangeMapping.put(path, change);
        }

        public Change getByPath(String path) {
            return this.myPathToChangeMapping.get(path);
        }

        private FilePath localDeletedPath(@NotNull String fullPath, boolean isDir) {
            if (fullPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullPath", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "localDeletedPath"));
            }
            SvnFileUrlMapping urlMapping = SvnChangeList.this.myVcs.getSvnFileUrlMapping();
            File file = urlMapping.getLocalPath(fullPath);
            if (file != null) {
                return VcsUtil.getFilePathForDeletedFile((String)file.getAbsolutePath(), (isDir || file.isDirectory() ? 1 : 0) != 0);
            }
            return null;
        }

        public SvnRepositoryContentRevision createDeletedItemRevision(String path, boolean isBeforeRevision) {
            boolean knownAsDirectory = SvnChangeList.this.myKnownAsDirectories.contains(path);
            String fullPath = SvnChangeList.this.myRepositoryRoot + path;
            if (!knownAsDirectory) {
                this.myWithoutDirStatus.add((Pair<Integer, Boolean>)Pair.create((Object)this.myList.size(), (Object)isBeforeRevision));
            }
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, this.localDeletedPath(fullPath, knownAsDirectory), SvnChangeList.this.getRevision(isBeforeRevision));
        }

        public SvnRepositoryContentRevision createRevisionLazily(String path, final boolean isBeforeRevision) {
            final boolean knownAsDirectory = SvnChangeList.this.myKnownAsDirectories.contains(path);
            FilePath localPath = SvnChangeList.this.getLocalPath(path, (NotNullFunction<File, Boolean>)((NotNullFunction)new NotNullFunction<File, Boolean>(){

                @NotNull
                public Boolean fun(File file) {
                    if (knownAsDirectory) {
                        Boolean bl = Boolean.TRUE;
                        if (bl == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper$1", "fun"));
                        }
                        return bl;
                    }
                    ChangesListCreationHelper.this.myWithoutDirStatus.add(new Pair((Object)ChangesListCreationHelper.this.myList.size(), (Object)isBeforeRevision));
                    Boolean bl = Boolean.FALSE;
                    if (bl == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper$1", "fun"));
                    }
                    return bl;
                }
            }));
            long revision = SvnChangeList.this.getRevision(isBeforeRevision);
            return localPath == null ? SvnRepositoryContentRevision.createForRemotePath(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, knownAsDirectory, revision) : SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, localPath, revision);
        }

        public List<Change> getList() {
            return this.myList;
        }

        public List<Change> getDetailedList() {
            if (this.myDetailedList == null) {
                this.myDetailedList = new ArrayList<Change>(this.myList);
                try {
                    this.doRemoteDetails();
                    this.uploadDeletedRenamedChildren();
                    ContainerUtil.removeDuplicates(this.myDetailedList);
                }
                catch (SVNException e) {
                    LOG.info((Throwable)e);
                }
                catch (VcsException e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.myDetailedList;
        }

        private void doRemoteDetails() throws SVNException, SvnBindException {
            for (Pair<Integer, Boolean> idxData : this.myWithoutDirStatus) {
                Change sourceChange = this.myDetailedList.get((Integer)idxData.first);
                SvnRepositoryContentRevision revision = (SvnRepositoryContentRevision)((Boolean)idxData.second != false ? sourceChange.getBeforeRevision() : sourceChange.getAfterRevision());
                if (revision == null) continue;
                SVNRevision beforeRevision = SVNRevision.create((long)SvnChangeList.this.getRevision((Boolean)idxData.second));
                Info info = SvnChangeList.this.myVcs.getInfo(SvnUtil.createUrl(revision.getFullPath()), beforeRevision, beforeRevision);
                boolean isDirectory = info != null && info.isDirectory();
                Change replacingChange = new Change((ContentRevision)this.createRevision((SvnRepositoryContentRevision)sourceChange.getBeforeRevision(), isDirectory), (ContentRevision)this.createRevision((SvnRepositoryContentRevision)sourceChange.getAfterRevision(), isDirectory));
                replacingChange.setIsReplaced(sourceChange.isIsReplaced());
                this.myDetailedList.set((Integer)idxData.first, replacingChange);
            }
            this.myWithoutDirStatus.clear();
        }

        @Nullable
        private SvnRepositoryContentRevision createRevision(SvnRepositoryContentRevision previousRevision, boolean isDir) {
            return previousRevision == null ? null : SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, previousRevision.getFullPath(), VcsUtil.getFilePath((String)previousRevision.getFile().getPath(), (boolean)isDir), previousRevision.getRevisionNumber().getRevision().getNumber());
        }

        private void uploadDeletedRenamedChildren() throws VcsException {
            Set<Pair<Boolean, String>> duplicates = this.collectDuplicates();
            List preprocessed = ChangesPreprocess.preprocessChangesRemoveDeletedForDuplicateMoved(this.myDetailedList);
            this.myDetailedList.addAll(this.collectDetails(preprocessed, duplicates));
        }

        private List<Change> collectDetails(@NotNull List<Change> changes, @NotNull Set<Pair<Boolean, String>> duplicates) throws VcsException {
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "collectDetails"));
            }
            if (duplicates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicates", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "collectDetails"));
            }
            ArrayList result = ContainerUtil.newArrayList();
            for (Change change : changes) {
                if (change.getAfterRevision() == null && change.getBeforeRevision().getFile().isDirectory()) {
                    result.addAll(this.getChildrenAsChanges(change.getBeforeRevision(), true, duplicates));
                    continue;
                }
                if (change.getBeforeRevision() == null && change.getAfterRevision().getFile().isDirectory()) {
                    if (!SvnChangeList.this.myCopiedAddedPaths.containsKey(this.getRelativePath(change.getAfterRevision()))) continue;
                    result.addAll(this.getChildrenAsChanges(change.getAfterRevision(), false, duplicates));
                    continue;
                }
                if (!change.isIsReplaced() && !change.isMoved() && !change.isRenamed() || !change.getAfterRevision().getFile().isDirectory()) continue;
                result.addAll(this.getChildrenAsChanges(change.getBeforeRevision(), true, duplicates));
                result.addAll(this.getChildrenAsChanges(change.getAfterRevision(), false, duplicates));
            }
            return result;
        }

        private Set<Pair<Boolean, String>> collectDuplicates() {
            HashSet result = ContainerUtil.newHashSet();
            for (Change change : this.myDetailedList) {
                this.addDuplicate(result, true, change.getBeforeRevision());
                this.addDuplicate(result, false, change.getAfterRevision());
            }
            return result;
        }

        private void addDuplicate(@NotNull Set<Pair<Boolean, String>> duplicates, boolean isBefore, @Nullable ContentRevision revision) {
            if (duplicates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicates", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "addDuplicate"));
            }
            if (revision != null) {
                duplicates.add((Pair<Boolean, String>)Pair.create((Object)isBefore, (Object)this.getRelativePath(revision)));
            }
        }

        @NotNull
        private String getRelativePath(@NotNull ContentRevision revision) {
            if (revision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "getRelativePath"));
            }
            String string = ((SvnRepositoryContentRevision)revision).getRelativePath(SvnChangeList.this.myRepositoryRoot);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "getRelativePath"));
            }
            return string;
        }

        @NotNull
        private Collection<Change> getChildrenAsChanges(@NotNull ContentRevision contentRevision, final boolean isBefore, final @NotNull Set<Pair<Boolean, String>> duplicates) throws VcsException {
            if (contentRevision == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRevision", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "getChildrenAsChanges"));
            }
            if (duplicates == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "duplicates", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "getChildrenAsChanges"));
            }
            final ArrayList<Change> result = new ArrayList<Change>();
            final String path = this.getRelativePath(contentRevision);
            SVNURL fullPath = SvnUtil.createUrl(((SvnRepositoryContentRevision)contentRevision).getFullPath());
            SVNRevision revisionNumber = SVNRevision.create((long)SvnChangeList.this.getRevision(isBefore));
            SvnTarget target = SvnTarget.fromURL((SVNURL)fullPath, (SVNRevision)revisionNumber);
            SvnChangeList.this.myVcs.getFactory(target).createBrowseClient().list(target, revisionNumber, Depth.INFINITY, new DirectoryEntryConsumer(){

                public void consume(DirectoryEntry entry) throws SVNException {
                    String childPath = path + '/' + entry.getRelativePath();
                    if (!duplicates.contains(Pair.create((Object)isBefore, (Object)childPath))) {
                        SvnRepositoryContentRevision contentRevision = ChangesListCreationHelper.this.createRevision(childPath, isBefore, entry.isDirectory());
                        result.add(new Change((ContentRevision)(isBefore ? contentRevision : null), (ContentRevision)(isBefore ? null : contentRevision)));
                    }
                }
            });
            ArrayList<Change> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/history/SvnChangeList$ChangesListCreationHelper", "getChildrenAsChanges"));
            }
            return arrayList;
        }

        private SvnRepositoryContentRevision createRevision(String path, boolean isBeforeRevision, boolean isDir) {
            return SvnRepositoryContentRevision.create(SvnChangeList.this.myVcs, SvnChangeList.this.myRepositoryRoot, path, SvnChangeList.this.getLocalPath(path, (NotNullFunction<File, Boolean>)((NotNullFunction)new ConstantFunction((Object)isDir))), SvnChangeList.this.getRevision(isBeforeRevision));
        }
    }
}

