/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.javaee.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.oss.server.JavaeeServerHomeProvider;
import com.intellij.javaee.oss.server.JavaeeServerVersionProvider;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.run.configuration.ApplicationServerSelectionListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.TomcatBundle;
import org.jetbrains.idea.tomcat.TomcatPersistentDataWrapper;
import org.jetbrains.idea.tomcat.server.TomcatIntegration;
import org.jetbrains.idea.tomcat.server.TomcatLocalModel;
import org.jetbrains.idea.tomcat.server.TomcatRunSettingsEditor;

public class TomcatLocalRunConfigurationEditor
extends TomcatRunSettingsEditor<TomcatLocalModel>
implements ApplicationServerSelectionListener {
    private JCheckBox myDeployTomcatApplicationsCheckBox;
    private JPanel myMainPanel;
    private JTextField myHttpPortTextField;
    private JTextField myHttpsPortTextField;
    private JCheckBox myPreserveSessionsCheckBox;
    private JTextField myJndiPortField;
    private JLabel myJndiPortLabel;
    private JTextField myAjpPortTextField;
    private boolean myOldLocalPortIsSource;
    private String myOldLocalPort;

    public TomcatLocalRunConfigurationEditor() {
        this.$$$setupUI$$$();
    }

    public void serverSelected(@Nullable ApplicationServer server) {
        this.updateSessionsCheckboxLabel(server);
        if (server != null && this.myOldLocalPortIsSource) {
            if (this.myOldLocalPort.equals(this.myHttpPortTextField.getText())) {
                TomcatPersistentDataWrapper persistentDataWrapper = new TomcatPersistentDataWrapper(server);
                String newSourceLocalPort = persistentDataWrapper.hasSourceLocalPort() ? String.valueOf(persistentDataWrapper.getSourceLocalPort()) : "";
                this.resetLocalPort(newSourceLocalPort);
            } else {
                this.myOldLocalPortIsSource = false;
            }
        }
    }

    public void serverProbablyEdited(@Nullable ApplicationServer server) {
        this.updateSessionsCheckboxLabel(server);
    }

    protected void applyEditorTo(TomcatLocalModel serverModel) throws ConfigurationException {
        serverModel.DEPLOY_TOMCAT_APPS = this.myDeployTomcatApplicationsCheckBox.isSelected();
        serverModel.setHttpPort(TomcatLocalRunConfigurationEditor.getTomcatPort(this.myHttpPortTextField, TomcatBundle.message("error.message.invalid.http.port.number", new Object[0])));
        serverModel.HTTPS_PORT = TomcatLocalRunConfigurationEditor.getTomcatPort(this.myHttpsPortTextField, TomcatBundle.message("error.message.invalid.secured.http.port.number", new Object[0]));
        serverModel.AJP_PORT = TomcatLocalRunConfigurationEditor.getTomcatPort(this.myAjpPortTextField, TomcatBundle.message("error.message.invalid.ajp.port.number", new Object[0]));
        serverModel.PRESERVE_SESSIONS = this.myPreserveSessionsCheckBox.isSelected();
        serverModel.JNDI_PORT = this.getJndiPort(this.myJndiPortField, serverModel);
    }

    private static int getTomcatPort(JTextField portTextField, String errorMessage) throws ConfigurationException {
        return StringUtil.isEmpty((String)portTextField.getText()) ? 0 : TomcatLocalRunConfigurationEditor.getPort((JTextField)portTextField, (String)errorMessage);
    }

    protected void resetEditorFrom(TomcatLocalModel serverModel) {
        this.updateSessionsCheckboxLabel(serverModel.getApplicationServer());
        this.myDeployTomcatApplicationsCheckBox.setSelected(serverModel.DEPLOY_TOMCAT_APPS);
        this.myOldLocalPortIsSource = serverModel.isSourceLocalPort();
        Integer httpPort = serverModel.getHttpPort();
        this.resetLocalPort(httpPort == null ? "" : String.valueOf(httpPort));
        int securedLocalPort = serverModel.HTTPS_PORT;
        this.myHttpsPortTextField.setText(securedLocalPort == 0 ? "" : String.valueOf(securedLocalPort));
        int ajpPort = serverModel.AJP_PORT;
        this.myAjpPortTextField.setText(ajpPort == 0 ? "" : String.valueOf(ajpPort));
        this.myPreserveSessionsCheckBox.setSelected(serverModel.PRESERVE_SESSIONS);
        boolean useJmx = serverModel.isUseJmx();
        this.myJndiPortLabel.setVisible(useJmx);
        this.myJndiPortField.setVisible(useJmx);
        this.myJndiPortField.setText(String.valueOf(serverModel.JNDI_PORT));
    }

    private void resetLocalPort(String localPort) {
        this.myOldLocalPort = localPort;
        this.myHttpPortTextField.setText(this.myOldLocalPort);
    }

    private void updateSessionsCheckboxLabel(ApplicationServer server) {
        String sessionsCheckboxName = TomcatBundle.message("checkbox.preserve.sessions.across.restarts.and.redeploys", new Object[0]);
        if (server != null) {
            boolean isSpecificVersion;
            boolean isTomEE = TomcatIntegration.isTomEE(new JavaeeServerHomeProvider(server).getValue());
            boolean bl = isSpecificVersion = new Version(new JavaeeServerVersionProvider(server).getValue()).getMajor() < 7;
            if (isTomEE || isSpecificVersion) {
                sessionsCheckboxName = TomcatBundle.message("checkbox.preserve.sessions.across.restarts", new Object[0]);
            }
        }
        this.myPreserveSessionsCheckBox.setText(sessionsCheckboxName);
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/TomcatLocalRunConfigurationEditor", "getEditor"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JLabel jLabel;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("label.http.port"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHttpPortTextField = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("label.https.port"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHttpsPortTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJndiPortField = jTextField2 = new JTextField();
        jTextField2.setColumns(4);
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myJndiPortLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("label.jmx.port"));
        jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDeployTomcatApplicationsCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("checkbox.deploy.tomcat.manager.text"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPreserveSessionsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("checkbox.preserve.sessions.across.restarts.and.redeploys"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/idea/tomcat/TomcatBundle").getString("label.ajp.port"));
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myAjpPortTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel2.setLabelFor(jTextField4);
        jLabel3.setLabelFor(jTextField3);
        jLabel.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

