/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.highlighting;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.websocket.highlighting.WebSocketBaseInspection;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.resources.WebSocketInspectionBundle;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ServerEndpointInconsistencyInspection
extends WebSocketBaseInspection {
    private static String[] METHOD_ANNOTATIONS = new String[]{"javax.websocket.OnOpen", "javax.websocket.OnClose", "javax.websocket.OnError"};

    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "checkClass"));
        }
        WebSocketEndpoint endpoint = WebSocketCommonUtils.getWebsocketEndpoint(aClass);
        boolean isAnnotatedEndpoint = endpoint != null;
        boolean isEndpointInheritor = InheritanceUtil.isInheritor((PsiClass)aClass, (String)"javax.websocket.Endpoint");
        if (!isAnnotatedEndpoint && !isEndpointInheritor) {
            return;
        }
        Set<PsiClass> decoders = endpoint == null ? Collections.emptySet() : endpoint.getDecoders();
        MultiMap methods = new MultiMap();
        HashSet onTextMessages = new HashSet();
        HashSet onBinaryMessages = new HashSet();
        HashSet onPongMessages = new HashSet();
        for (PsiMethod method : aClass.getMethods()) {
            for (String s : METHOD_ANNOTATIONS) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)s, (boolean)true)) continue;
                methods.putValue((Object)s, (Object)method);
                break;
            }
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"javax.websocket.OnMessage", (boolean)true)) continue;
            if (WebSocketCommonUtils.isTextMessageProcessingMethod(method, decoders)) {
                onTextMessages.add(method);
                continue;
            }
            if (WebSocketCommonUtils.isBinaryMessageProcessingMethod(method, decoders)) {
                onBinaryMessages.add(method);
                continue;
            }
            if (!WebSocketCommonUtils.isPongMessageProcessingMethod(method)) continue;
            onPongMessages.add(method);
        }
        ServerEndpointInconsistencyInspection.checkOnMessageMultipleMethods(holder, (Set<PsiMethod>)onTextMessages, "text");
        ServerEndpointInconsistencyInspection.checkOnMessageMultipleMethods(holder, (Set<PsiMethod>)onBinaryMessages, "binary");
        ServerEndpointInconsistencyInspection.checkOnMessageMultipleMethods(holder, (Set<PsiMethod>)onPongMessages, "pong");
        ServerEndpointInconsistencyInspection.checkLifecycleMethods(holder, isEndpointInheritor, (MultiMap<String, PsiMethod>)methods);
    }

    private static void checkLifecycleMethods(@NotNull ProblemsHolder holder, boolean isEndpointInheritor, @NotNull MultiMap<String, PsiMethod> methods) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "checkLifecycleMethods"));
        }
        if (methods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methods", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "checkLifecycleMethods"));
        }
        for (Map.Entry entry : methods.entrySet()) {
            PsiIdentifier identifier;
            Collection psiMethods = (Collection)entry.getValue();
            String shortName = "@" + StringUtil.getShortName((String)((String)entry.getKey()));
            if (isEndpointInheritor) {
                if (psiMethods.size() <= 0) continue;
                for (PsiMethod method : psiMethods) {
                    identifier = method.getNameIdentifier();
                    if (identifier == null) continue;
                    holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("ServerEndpointInconsistencyInspection.methods.are.not.allowed", shortName, "javax.websocket.Endpoint"), new LocalQuickFix[0]);
                }
                continue;
            }
            if (psiMethods.size() <= 1) continue;
            for (PsiMethod method : psiMethods) {
                identifier = method.getNameIdentifier();
                if (identifier == null) continue;
                holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("ServerEndpointInconsistencyInspection.multiple.method.declarations", shortName), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkOnMessageMultipleMethods(@NotNull ProblemsHolder holder, @NotNull Set<PsiMethod> psiMethods, @NotNull String text) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "checkOnMessageMultipleMethods"));
        }
        if (psiMethods == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethods", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "checkOnMessageMultipleMethods"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "checkOnMessageMultipleMethods"));
        }
        if (psiMethods.size() > 1) {
            for (PsiMethod psiMethod : psiMethods) {
                PsiIdentifier identifier = psiMethod.getNameIdentifier();
                if (identifier == null) continue;
                holder.registerProblem((PsiElement)identifier, WebSocketInspectionBundle.message("ServerEndpointInconsistencyInspection.multiple.on.message.method.declarations", text), new LocalQuickFix[0]);
            }
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = WebSocketInspectionBundle.message("inspection.name.server.endpoint.inconsistency.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("ServerEndpointInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "getShortName"));
        }
        return "ServerEndpointInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/highlighting/ServerEndpointInconsistencyInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

