/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.providers;

import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.model.gotosymbol.GoToSymbolProvider;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketJamModel;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import com.intellij.websocket.utils.WebSocketCommonUtils;
import icons.WebSocketIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class WebSocketGotoSymbolProvider
extends GoToSymbolProvider {
    protected void addNames(@NotNull Module module, Set<String> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/providers/WebSocketGotoSymbolProvider", "addNames"));
        }
        List<WebSocketServerEndpoint> endpoints = WebSocketJamModel.getModel(module.getProject()).getServerEndpoints(module);
        result.addAll(ContainerUtil.mapNotNull(endpoints, (Function)new Function<WebSocketEndpoint, String>(){

            public String fun(WebSocketEndpoint endpoint) {
                return endpoint.getPath();
            }
        }));
    }

    protected void addItems(@NotNull Module module, String name, List<NavigationItem> result) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/websocket/providers/WebSocketGotoSymbolProvider", "addItems"));
        }
        for (WebSocketServerEndpoint endpoint : WebSocketJamModel.getModel(module.getProject()).getServerEndpoints(module)) {
            NavigationItem navigationItem;
            PsiNamedElement element = endpoint.getIdentifyingPsiElement();
            String elementName = element.getName();
            if (elementName == null || !elementName.trim().startsWith(name) || result.contains(navigationItem = WebSocketGotoSymbolProvider.createNavigationItem((PsiElement)element, (String)elementName, (Icon)WebSocketIcons.WebSocketFramework))) continue;
            result.add(navigationItem);
        }
    }

    protected boolean acceptModule(Module module) {
        return WebSocketCommonUtils.isWebSocketInstalled(module);
    }
}

