/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.websocket.utils;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.websocket.constants.WebSocketAnnoConstants;
import com.intellij.websocket.jam.WebSocketClientEndpoint;
import com.intellij.websocket.jam.WebSocketEndpoint;
import com.intellij.websocket.jam.WebSocketPathParam;
import com.intellij.websocket.jam.WebSocketServerEndpoint;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebSocketCommonUtils {
    private WebSocketCommonUtils() {
    }

    public static boolean isWebSocketInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("javax.websocket.server.ServerEndpoint", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }

    @Nullable
    public static WebSocketEndpoint getWebsocketEndpoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/websocket/utils/WebSocketCommonUtils", "getWebsocketEndpoint"));
        }
        return (WebSocketEndpoint)JamService.getJamService((Project)psiClass.getProject()).getJamElement(WebSocketEndpoint.WEB_SOCKET_JAM_KEY, (PsiElement)psiClass);
    }

    @NotNull
    public static List<WebSocketPathParam> getPathParams(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/websocket/utils/WebSocketCommonUtils", "getPathParams"));
        }
        ArrayList<WebSocketPathParam> params = new ArrayList<WebSocketPathParam>();
        JamService service = JamService.getJamService((Project)psiClass.getProject());
        PsiFile file = psiClass.getContainingFile().getOriginalFile();
        PsiClass annoClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("javax.websocket.server.PathParam", GlobalSearchScope.allScope((Project)psiClass.getProject()));
        if (annoClass != null) {
            for (PsiParameter parameter : AnnotatedElementsSearch.searchPsiParameters((PsiClass)annoClass, (SearchScope)GlobalSearchScope.fileScope((PsiFile)file.getOriginalFile())).findAll()) {
                WebSocketPathParam param = (WebSocketPathParam)service.getJamElement((PsiElement)parameter, new JamMemberMeta[]{WebSocketPathParam.META});
                if (param == null) continue;
                params.add(param);
            }
        }
        ArrayList<WebSocketPathParam> arrayList = params;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/websocket/utils/WebSocketCommonUtils", "getPathParams"));
        }
        return arrayList;
    }

    @Nullable
    public static WebSocketServerEndpoint getServerEndpoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/websocket/utils/WebSocketCommonUtils", "getServerEndpoint"));
        }
        return (WebSocketServerEndpoint)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{WebSocketServerEndpoint.META});
    }

    @Nullable
    public static WebSocketClientEndpoint getClientEndpoint(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/websocket/utils/WebSocketCommonUtils", "getClientEndpoint"));
        }
        return (WebSocketClientEndpoint)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{WebSocketClientEndpoint.META});
    }

    public static boolean isTextMessageProcessingMethod(@NotNull PsiMethod type, @NotNull Set<PsiClass> decoders) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "isTextMessageProcessingMethod"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "isTextMessageProcessingMethod"));
        }
        for (PsiParameter parameter : type.getParameterList().getParameters()) {
            if (!WebSocketCommonUtils.isTextMessageParameterType(parameter.getType(), type.getProject(), decoders)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBinaryMessageProcessingMethod(@NotNull PsiMethod method, @NotNull Set<PsiClass> decoders) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/websocket/utils/WebSocketCommonUtils", "isBinaryMessageProcessingMethod"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "isBinaryMessageProcessingMethod"));
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!WebSocketCommonUtils.isBinaryMessageParameterType(parameter.getType(), method.getProject(), decoders)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPongMessageProcessingMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/websocket/utils/WebSocketCommonUtils", "isPongMessageProcessingMethod"));
        }
        for (PsiParameter parameter : method.getParameterList().getParameters()) {
            if (!WebSocketCommonUtils.isPongMessageParameterType(parameter.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPongMessageParameterType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)"javax.websocket.PongMessage");
    }

    public static boolean isBinaryMessageParameterType(@NotNull PsiType type, @NotNull Project project, @NotNull Set<PsiClass> decoders) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "isBinaryMessageParameterType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/utils/WebSocketCommonUtils", "isBinaryMessageParameterType"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "isBinaryMessageParameterType"));
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.io.InputStream")) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.nio.ByteBuffer")) {
            return true;
        }
        if (type instanceof PsiArrayType && ((PsiArrayType)type).getComponentType().equals(PsiType.BYTE)) {
            return true;
        }
        return WebSocketCommonUtils.hasBinaryDecoderForType(type, decoders, project);
    }

    public static boolean isTextMessageParameterType(@NotNull PsiType type, @NotNull Project project, @NotNull Set<PsiClass> decoders) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "isTextMessageParameterType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/utils/WebSocketCommonUtils", "isTextMessageParameterType"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "isTextMessageParameterType"));
        }
        if (type instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType((PsiType)type) != null) {
            return true;
        }
        if ("java.lang.String".equals(type.getCanonicalText())) {
            return true;
        }
        if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.io.Reader")) {
            return true;
        }
        return WebSocketCommonUtils.hasTextDecoderForType(type, decoders, project);
    }

    public static boolean hasTextDecoderForType(@NotNull PsiType type, @NotNull Set<PsiClass> decoders, @NotNull Project project) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasTextDecoderForType"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasTextDecoderForType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasTextDecoderForType"));
        }
        return WebSocketCommonUtils.hasDecoderForType(type, decoders, project, WebSocketAnnoConstants.TEXT_DECODERS);
    }

    private static boolean hasBinaryDecoderForType(@NotNull PsiType type, @NotNull Set<PsiClass> decoders, @NotNull Project project) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasBinaryDecoderForType"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasBinaryDecoderForType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasBinaryDecoderForType"));
        }
        return WebSocketCommonUtils.hasDecoderForType(type, decoders, project, WebSocketAnnoConstants.BINARY_DECODERS);
    }

    private static boolean hasDecoderForType(@NotNull PsiType type, @NotNull Set<PsiClass> decoders, @NotNull Project project, @NotNull String[] decodersBaseClasses) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasDecoderForType"));
        }
        if (decoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasDecoderForType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasDecoderForType"));
        }
        if (decodersBaseClasses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decodersBaseClasses", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasDecoderForType"));
        }
        for (PsiClass decoder : decoders) {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(decoder);
            for (String decoderBaseClass : decodersBaseClasses) {
                PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)decoderBaseClass, (int)0, (boolean)false);
                if (psiType == null || !type.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasEncoderForType(@NotNull PsiType type, @NotNull Set<PsiClass> encoders, Project project) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasEncoderForType"));
        }
        if (encoders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encoders", "com/intellij/websocket/utils/WebSocketCommonUtils", "hasEncoderForType"));
        }
        for (PsiClass encoder : encoders) {
            PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(encoder);
            for (String encoderBaseClass : WebSocketAnnoConstants.ENCODERS) {
                PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)encoderBaseClass, (int)0, (boolean)false);
                if (psiType == null || !type.isAssignableFrom(psiType)) continue;
                return true;
            }
        }
        return false;
    }
}

