/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.psi.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.xml.XmlAttributeImpl;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.HAMLVisitor;

public final class HAMLAttributeImpl
extends XmlAttributeImpl {
    @NotNull
    public String getLocalName() {
        String string = this.patchName(super.getLocalName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLAttributeImpl", "getLocalName"));
        }
        return string;
    }

    private String patchName(String name) {
        ASTNode node;
        if (!StringUtil.isEmpty((String)name)) {
            return name;
        }
        PsiElement firstChild = this.getFirstChild();
        ASTNode aSTNode = node = firstChild != null ? firstChild.getNode() : null;
        if (node != null) {
            if (node.getElementType() == HAMLTokenTypes.ID_START) {
                return "id";
            }
            if (node.getElementType() == HAMLTokenTypes.CLASS_START) {
                return "class";
            }
        }
        return name;
    }

    @NotNull
    public PsiReference[] getReferences(@NotNull PsiReferenceService.Hints hints) {
        ASTNode node;
        if (hints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hints", "org/jetbrains/plugins/haml/psi/impl/HAMLAttributeImpl", "getReferences"));
        }
        PsiReference[] refs = super.getReferences(hints);
        PsiElement firstChild = this.getFirstChild();
        ASTNode aSTNode = node = firstChild != null ? firstChild.getNode() : null;
        if (node != null && (node.getElementType() == HAMLTokenTypes.ID_START || node.getElementType() == HAMLTokenTypes.CLASS_START)) {
            ArrayList cleanedRefs = Lists.newArrayList((Iterable)Collections2.filter(Arrays.asList(refs), (Predicate)new Predicate<PsiReference>(){

                public boolean apply(@Nullable PsiReference ref) {
                    return ref != null && !ref.getRangeInElement().isEmpty();
                }
            }));
            refs = cleanedRefs.toArray(new PsiReference[cleanedRefs.size()]);
        }
        if (refs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLAttributeImpl", "getReferences"));
        }
        return refs;
    }

    @NotNull
    public String getName() {
        String string = this.patchName(super.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLAttributeImpl", "getName"));
        }
        return string;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/plugins/haml/psi/impl/HAMLAttributeImpl", "accept"));
        }
        if (visitor instanceof HAMLVisitor) {
            ((HAMLVisitor)visitor).visitHAMLAttribute(this);
        }
        super.accept(visitor);
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        return null;
    }
}

