/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.haml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlTagImpl;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CharTable;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.haml.psi.HAMLAttributeProvider;
import org.jetbrains.plugins.haml.psi.HAMLElementTypes;
import org.jetbrains.plugins.haml.psi.HAMLTokenTypes;
import org.jetbrains.plugins.haml.psi.impl.HAMLClassOrIdImpl;

public class HAMLTagImpl
extends XmlTagImpl
implements HtmlTag,
PsiLanguageInjectionHost {
    public HAMLTagImpl() {
        super(HAMLElementTypes.HAML_TAG);
    }

    @NotNull
    public String getName() {
        String name = super.getName();
        String string = !StringUtil.isEmpty((String)name) ? name : "div";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl", "getName"));
        }
        return string;
    }

    public boolean isTagNameEmpty() {
        String name = super.getName();
        return StringUtil.isEmpty((String)name);
    }

    public String toString() {
        return "HAMLTag:" + this.getName();
    }

    public String getAttributeValue(String qname) {
        for (HAMLAttributeProvider provider : (HAMLAttributeProvider[])HAMLAttributeProvider.EP_NAME.getExtensions()) {
            String attribute = provider.getAttribute(this, qname);
            if (attribute == null) continue;
            return attribute;
        }
        return super.getAttributeValue(qname);
    }

    protected void cacheOneAttributeValue(String name, String value, Map<String, String> attributesValueMap) {
        if ("class".equals(name)) {
            XmlAttribute[] attributes = this.getAttributes();
            StringBuilder attributeValue = new StringBuilder();
            for (XmlAttribute attribute : attributes) {
                if (!"class".equals(attribute.getName())) continue;
                attributeValue.append(attribute.getValue()).append(' ');
            }
            attributesValueMap.put(name, attributeValue.toString().trim());
        } else {
            super.cacheOneAttributeValue(name, value, attributesValueMap);
        }
    }

    @NotNull
    public String getNamespace() {
        String xmlNamespace = super.getNamespace();
        if (this.getNamespacePrefix().length() > 0) {
            String string = xmlNamespace;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl", "getNamespace"));
            }
            return string;
        }
        if (xmlNamespace.length() == 0 || xmlNamespace.equals("http://www.w3.org/1999/xhtml")) {
            if ("http://www.w3.org/1999/html" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl", "getNamespace"));
            }
            return "http://www.w3.org/1999/html";
        }
        String string = xmlNamespace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl", "getNamespace"));
        }
        return string;
    }

    protected String getRealNs(String value) {
        if ("http://www.w3.org/1999/xhtml".equals(value)) {
            return "http://www.w3.org/1999/html";
        }
        return value;
    }

    public String getPrefixByNamespace(String namespace) {
        if ("http://www.w3.org/1999/html".equals(namespace)) {
            namespace = "http://www.w3.org/1999/xhtml";
        }
        return super.getPrefixByNamespace(namespace);
    }

    public XmlAttribute getAttribute(String qname) {
        if (qname == null) {
            return null;
        }
        CharTable charTableByTree = SharedImplUtil.findCharTableByTree((ASTNode)this);
        XmlAttribute[] attributes = this.getAttributes();
        CharSequence charTableIndex = charTableByTree.intern((CharSequence)qname);
        boolean caseSensitive = this.isCaseSensitive();
        for (XmlAttribute attribute : attributes) {
            CharSequence name;
            ASTNode attrNameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(attribute.getNode());
            CharSequence charSequence = attrNameElement instanceof HAMLClassOrIdImpl ? charTableByTree.intern((CharSequence)attribute.getLocalName()) : (name = attrNameElement != null ? attrNameElement.getChars() : null);
            if (name == null || (!caseSensitive || !name.equals(charTableIndex)) && (caseSensitive || !Comparing.equal((CharSequence)name, (CharSequence)charTableIndex, (boolean)false))) continue;
            return attribute;
        }
        return null;
    }

    public XmlElementDescriptor getDescriptor() {
        XmlTag parentTag;
        TreeElement node = this.getFirstChildNode();
        if (node != null && node.getElementType() == HAMLTokenTypes.RUBY_CODE_MARKER && (parentTag = this.getParentTag()) != null) {
            return parentTag.getDescriptor();
        }
        return super.getDescriptor();
    }

    public boolean isValidHost() {
        return true;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl", "updateText"));
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        LiteralTextEscaper literalTextEscaper = LiteralTextEscaper.createSimple((PsiLanguageInjectionHost)this);
        if (literalTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/haml/psi/impl/HAMLTagImpl", "createLiteralTextEscaper"));
        }
        return literalTextEscaper;
    }
}

