/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.Bytecode;
import com.intellij.zkm.bytecode.ClassProvider;
import com.intellij.zkm.bytecode.Invocation;
import com.intellij.zkm.bytecode.InvocationReader;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.SignatureReader;
import com.intellij.zkm.bytecode.Utilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class BytecodeImpl
implements Bytecode {
    private final ClassProvider myClassProvider;
    private final SignatureReader mySignatureReader;
    private final InvocationReader myInvocationReader;
    private final Map<String, List<Set<Signature>>> mySignaturesCache;
    private final Map<String, ArrayList<Map<Signature, Set<Invocation>>>> myInvocationsCache;

    BytecodeImpl(@NotNull ClassProvider classProvider, @NotNull SignatureReader signatureReader, @NotNull InvocationReader invocationReader) throws IOException {
        if (classProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classProvider", "com/intellij/zkm/bytecode/BytecodeImpl", "<init>"));
        }
        if (signatureReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureReader", "com/intellij/zkm/bytecode/BytecodeImpl", "<init>"));
        }
        if (invocationReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocationReader", "com/intellij/zkm/bytecode/BytecodeImpl", "<init>"));
        }
        this.mySignaturesCache = new HashMap<String, List<Set<Signature>>>();
        this.myInvocationsCache = new HashMap<String, ArrayList<Map<Signature, Set<Invocation>>>>();
        this.myClassProvider = classProvider;
        this.mySignatureReader = signatureReader;
        this.myInvocationReader = invocationReader;
    }

    @Override
    public boolean contains(@NotNull String className) {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/BytecodeImpl", "contains"));
        }
        return this.mySignaturesCache.containsKey(className) || this.myInvocationsCache.containsKey(className) || this.myClassProvider.contains(className);
    }

    @Override
    @NotNull
    public Set<Signature> getSignaturesAt(@NotNull String className, int lineNumber) throws IOException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/BytecodeImpl", "getSignaturesAt"));
        }
        List<Set<Signature>> list = this.mySignaturesCache.get(className);
        if (list == null) {
            list = this.readSignatures(className);
            this.mySignaturesCache.put(className, list);
        }
        if (lineNumber < 0 || lineNumber >= list.size()) {
            throw new IndexOutOfBoundsException(String.format("Line number is outside of [%d, %d): %d", 0, list.size(), lineNumber));
        }
        Set<Signature> set = Collections.unmodifiableSet(list.get(lineNumber));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/BytecodeImpl", "getSignaturesAt"));
        }
        return set;
    }

    private List<Set<Signature>> readSignatures(String className) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(this.myClassProvider.getInputStream(className));){
            List<Set<Signature>> list = this.mySignatureReader.read(stream);
            return list;
        }
    }

    @Override
    @NotNull
    public Map<Signature, Set<Invocation>> getInvocationsAt(@NotNull String className, int lineNumber) throws IOException {
        Map<Signature, Set<Invocation>> invocations;
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/BytecodeImpl", "getInvocationsAt"));
        }
        ArrayList<Map<Signature, Set<Invocation>>> list = this.myInvocationsCache.get(className);
        if (list == null) {
            list = new ArrayList();
            this.myInvocationsCache.put(className, list);
        }
        Map<Signature, Set<Invocation>> map = invocations = lineNumber < list.size() ? list.get(lineNumber) : null;
        if (invocations == null) {
            invocations = this.readInvocationsAt(className, lineNumber);
            Utilities.ensureSize(list, lineNumber + 1, () -> null);
            list.set(lineNumber, invocations);
        }
        Map<Signature, Set<Invocation>> map2 = Collections.unmodifiableMap(invocations);
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/BytecodeImpl", "getInvocationsAt"));
        }
        return map2;
    }

    private Map<Signature, Set<Invocation>> readInvocationsAt(@NotNull String className, int lineNumber) throws IOException {
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/zkm/bytecode/BytecodeImpl", "readInvocationsAt"));
        }
        try (BufferedInputStream stream = new BufferedInputStream(this.myClassProvider.getInputStream(className));){
            Map<Signature, Set<Invocation>> map = this.myInvocationReader.read(stream, lineNumber);
            return map;
        }
    }
}

