/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.ClassData;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClassDataImpl
implements ClassData {
    private final Map<String, ? extends ClassData> myClasses;
    private String myClassName;
    private String mySourceFile;
    private Map<String, Set<Signature>> mySignatures;

    ClassDataImpl(@NotNull Map<String, ? extends ClassData> classes) {
        if (classes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classes", "com/intellij/zkm/bytecode/ClassDataImpl", "<init>"));
        }
        this.mySignatures = new HashMap<String, Set<Signature>>();
        this.myClasses = classes;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    void setClassName(@Nullable String originalName) {
        this.myClassName = originalName;
    }

    @Override
    @Nullable
    public String getSourceFile() {
        return this.mySourceFile;
    }

    void setSourceFile(@Nullable String sourceFile) {
        this.mySourceFile = sourceFile;
    }

    @Override
    @NotNull
    public Set<Signature> getSignatures(@NotNull String methodName) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/zkm/bytecode/ClassDataImpl", "getSignatures"));
        }
        Set<Signature> signatures = this.mySignatures.get(methodName);
        if (signatures != null) {
            signatures = this.translate(signatures);
        }
        Set<Object> set = signatures == null ? Collections.emptySet() : Collections.unmodifiableSet(signatures);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/ClassDataImpl", "getSignatures"));
        }
        return set;
    }

    void add(@NotNull String methodName, @NotNull Signature signature) {
        if (methodName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodName", "com/intellij/zkm/bytecode/ClassDataImpl", "add"));
        }
        if (signature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signature", "com/intellij/zkm/bytecode/ClassDataImpl", "add"));
        }
        Set<Signature> signatures = this.mySignatures.get(methodName);
        if (signatures == null) {
            signatures = new HashSet<Signature>();
            this.mySignatures.put(methodName, signatures);
        }
        signatures.add(signature);
    }

    private Set<Signature> translate(Set<Signature> signatures) {
        return signatures.stream().map(signature -> new Signature(signature.getModifiers(), this.translate(signature.getReturnType()), signature.getName(), signature.getParameterTypes().stream().map(this::translate).collect(Collectors.toList()))).collect(Collectors.toSet());
    }

    private Type translate(Type type) {
        if (type.isPrimitive()) {
            return type;
        }
        ClassData data = this.myClasses.get(type.getClassName());
        if (data == null || data.getClassName() == null || type.getClassName().equals(data.getClassName())) {
            return type;
        }
        return new Type(data.getClassName(), type.isArray());
    }

    @Override
    public int getLineNumber(int lineNumber) {
        return lineNumber;
    }

    boolean isEmpty() {
        return this.myClassName == null && this.mySourceFile == null && this.mySignatures.isEmpty();
    }
}

