/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.zkm.bytecode;

import com.intellij.zkm.bytecode.BytecodeReader;
import com.intellij.zkm.bytecode.Signature;
import com.intellij.zkm.bytecode.SignatureReader;
import com.intellij.zkm.bytecode.TypeFactory;
import com.intellij.zkm.bytecode.Utilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

class SignatureReaderImpl
extends BytecodeReader
implements SignatureReader {
    SignatureReaderImpl(@NotNull TypeFactory types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/zkm/bytecode/SignatureReaderImpl", "<init>"));
        }
        super(types);
    }

    @Override
    @NotNull
    public List<Set<Signature>> read(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/zkm/bytecode/SignatureReaderImpl", "read"));
        }
        ClassReader reader = new ClassReader(stream);
        SignatureCollector collector = new SignatureCollector();
        reader.accept((ClassVisitor)collector, 4);
        List<Set<Signature>> list = collector.getSignatures();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/zkm/bytecode/SignatureReaderImpl", "read"));
        }
        return list;
    }

    private class SignatureCollector
    extends ClassVisitor {
        private ArrayList<Set<Signature>> mySignatures;

        SignatureCollector() {
            super(393216);
            this.mySignatures = new ArrayList(256);
        }

        public MethodVisitor visitMethod(final int access, final String name, final String desc, String signature, String[] exceptions) {
            return new MethodVisitor(393216){

                public void visitLineNumber(int line, Label start) {
                    Utilities.ensureSize(SignatureCollector.this.mySignatures, line + 1, HashSet::new);
                    ((Set)SignatureCollector.this.mySignatures.get(line)).add(SignatureReaderImpl.this.createSignature(access, name, desc));
                }
            };
        }

        List<Set<Signature>> getSignatures() {
            return Collections.unmodifiableList(this.mySignatures);
        }
    }
}

