/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.ws.actions;

import com.intellij.ide.actions.CreateFileAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.ws.SpringWebServicesBundle;
import icons.SpringApiIcons;
import org.jetbrains.annotations.NotNull;

public class CreateWebServiceConfigAction
extends CreateFileAction {
    public CreateWebServiceConfigAction() {
        super(SpringWebServicesBundle.message("config.new.file", new Object[0]), SpringWebServicesBundle.message("create.new.spring.configuration.file", new Object[0]), SpringApiIcons.SpringConfig);
    }

    protected boolean isAvailable(DataContext dataContext) {
        if (!super.isAvailable(dataContext)) {
            return false;
        }
        Module module = (Module)LangDataKeys.MODULE.getData(dataContext);
        return SpringCommonUtils.hasSpringFacet((Module)module);
    }

    @NotNull
    protected PsiElement[] create(String newName, PsiDirectory directory) throws Exception {
        FileTemplate template = FileTemplateManager.getInstance((Project)directory.getProject()).getJ2eeTemplate("spring.security.config.xml");
        String fileName = this.getFileName(newName);
        PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, null, (PsiDirectory)directory);
        PsiElement[] psiElementArray = new PsiElement[]{psiElement};
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/ws/actions/CreateWebServiceConfigAction", "create"));
        }
        return psiElementArray;
    }

    protected String getDefaultExtension() {
        return "xml";
    }
}

