/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class CompilerTestUtil {
    private CompilerTestUtil() {
    }

    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance(project);
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    public static void saveApplicationSettings() {
        EdtTestUtil.runInEdtAndWait(() -> {
            CompilerTestUtil.doSaveComponent(ProjectJdkTable.getInstance());
            CompilerTestUtil.doSaveComponent(FileTypeManager.getInstance());
        });
    }

    public static void saveApplicationComponent(Object appComponent) {
        EdtTestUtil.runInEdtAndWait(() -> CompilerTestUtil.doSaveComponent(appComponent));
    }

    private static void doSaveComponent(Object appComponent) {
        ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).saveApplicationComponent(appComponent);
    }

    public static void enableExternalCompiler() {
        final JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
        new WriteAction(){

            @Override
            protected void run(@NotNull Result result) {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/compiler/CompilerTestUtil$1", "run"));
                }
                table.addJdk(table.getInternalJdk());
            }
        }.execute();
    }

    public static void disableExternalCompiler(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/CompilerTestUtil", "disableExternalCompiler"));
        }
        EdtTestUtil.runInEdtAndWait(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/CompilerTestUtil", "lambda$disableExternalCompiler$3"));
            }
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            ApplicationManager.getApplication().runWriteAction(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/CompilerTestUtil", "lambda$null$2"));
                }
                Sdk internalJdk = table.getInternalJdk();
                SmartList modulesToRestore = new SmartList();
                for (Module module : ModuleManager.getInstance(project).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance(module).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    modulesToRestore.add(module);
                }
                table.removeJdk(internalJdk);
                for (Module module : modulesToRestore) {
                    ModuleRootModificationUtil.setModuleSdk(module, internalJdk);
                }
                BuildManager.getInstance().clearState(project);
            });
        });
    }
}

