/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaCommandLine;
import com.intellij.execution.configurations.JavaCommandLineStateUtil;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import org.jetbrains.annotations.NotNull;

public abstract class JavaCommandLineState
extends CommandLineState
implements JavaCommandLine {
    private JavaParameters myParams;

    protected JavaCommandLineState(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "environment", "com/intellij/execution/configurations/JavaCommandLineState", "<init>"));
        }
        super(environment);
    }

    @Override
    public JavaParameters getJavaParameters() throws ExecutionException {
        if (this.myParams == null) {
            this.myParams = this.createJavaParameters();
        }
        return this.myParams;
    }

    public void clear() {
        this.myParams = null;
    }

    @NotNull
    protected OSProcessHandler startProcess() throws ExecutionException {
        OSProcessHandler oSProcessHandler = JavaCommandLineStateUtil.startProcess(this.createCommandLine(), this.ansiColoringEnabled());
        if (oSProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/JavaCommandLineState", "startProcess"));
        }
        return oSProcessHandler;
    }

    protected boolean ansiColoringEnabled() {
        return true;
    }

    protected abstract JavaParameters createJavaParameters() throws ExecutionException;

    protected GeneralCommandLine createCommandLine() throws ExecutionException {
        JavaParameters javaParameters = this.getJavaParameters();
        javaParameters.setUseDynamicClasspath(this.getEnvironment().getProject());
        return javaParameters.toCommandLine();
    }

    public boolean shouldAddJavaProgramRunnerActions() {
        return true;
    }
}

