/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.filters.ExceptionFilterFactory;
import com.intellij.execution.filters.ExceptionInfoCache;
import com.intellij.execution.filters.ExceptionWorker;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionExFilterFactory
implements ExceptionFilterFactory {
    @Override
    @NotNull
    public Filter create(@NotNull GlobalSearchScope searchScope) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/execution/filters/ExceptionExFilterFactory", "create"));
        }
        MyFilter myFilter = new MyFilter(searchScope);
        if (myFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionExFilterFactory", "create"));
        }
        return myFilter;
    }

    private static class MyFilter
    implements Filter,
    FilterMixin {
        private final ExceptionInfoCache myCache;

        public MyFilter(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter", "<init>"));
            }
            this.myCache = new ExceptionInfoCache(scope);
        }

        @Override
        public Filter.Result applyFilter(String line, int textEndOffset) {
            return null;
        }

        @Override
        public boolean shouldRunHeavy() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<FilterMixin.AdditionalHighlight> consumer) {
            if (copiedFragment == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copiedFragment", "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter", "applyHeavyFilter"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter", "applyHeavyFilter"));
            }
            THashMap visited = new THashMap();
            Trinity emptyInfo = Trinity.create(null, null, null);
            ExceptionWorker worker = new ExceptionWorker(this.myCache);
            for (int i = 0; i < copiedFragment.getLineCount(); ++i) {
                Trinity<TextRange, TextRange, TextRange> info;
                int lineEndOffset;
                int lineStartOffset = copiedFragment.getLineStartOffset(i);
                String lineText = copiedFragment.getText(new TextRange(lineStartOffset, lineEndOffset = copiedFragment.getLineEndOffset(i)));
                if (!lineText.contains(".java:") || (info = (Trinity<TextRange, TextRange, TextRange>)visited.get(lineText)) == emptyInfo) continue;
                if (info == null) {
                    info = emptyInfo;
                    AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
                    try {
                        PsiCodeBlock tryBlock;
                        int offset;
                        PsiFile psiFile;
                        OpenFileDescriptor descriptor;
                        HyperlinkInfo hyperlinkInfo;
                        Filter.Result result = worker.execute(lineText, lineEndOffset);
                        if (result == null || !((hyperlinkInfo = result.getHyperlinkInfo()) instanceof FileHyperlinkInfo) || (descriptor = ((FileHyperlinkInfo)hyperlinkInfo).getDescriptor()) == null || (psiFile = worker.getFile()) == null || psiFile instanceof PsiCompiledFile || (offset = descriptor.getOffset()) <= 0) continue;
                        PsiElement element = psiFile.findElementAt(offset);
                        PsiTryStatement parent = PsiTreeUtil.getParentOfType(element, PsiTryStatement.class, true, PsiClass.class);
                        PsiCodeBlock psiCodeBlock = tryBlock = parent != null ? parent.getTryBlock() : null;
                        if (tryBlock == null || !tryBlock.getTextRange().contains(offset)) continue;
                        info = worker.getInfo();
                    }
                    finally {
                        token.finish();
                        visited.put(lineText, info);
                    }
                }
                int off = startOffset + lineStartOffset;
                final Color color = UIUtil.getInactiveTextColor();
                consumer.consume((Object)new FilterMixin.AdditionalHighlight(off + ((TextRange)info.first).getStartOffset(), off + ((TextRange)info.second).getEndOffset()){

                    @Override
                    @NotNull
                    public TextAttributes getTextAttributes(@Nullable TextAttributes source) {
                        TextAttributes textAttributes = new TextAttributes(null, null, color, EffectType.BOLD_DOTTED_LINE, 0);
                        if (textAttributes == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter$1", "getTextAttributes"));
                        }
                        return textAttributes;
                    }
                });
            }
        }

        @Override
        @NotNull
        public String getUpdateMessage() {
            if ("Highlighting try blocks..." == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionExFilterFactory$MyFilter", "getUpdateMessage"));
            }
            return "Highlighting try blocks...";
        }
    }
}

