/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jam;

import com.intellij.jam.JamAttributeElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElementRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JamBooleanAttributeElement
extends JamAttributeElement<Boolean> {
    private final boolean myDefaultValue;

    public JamBooleanAttributeElement(String attributeName, @NotNull PsiElementRef<PsiAnnotation> parent, boolean defaultValue) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/jam/JamBooleanAttributeElement", "<init>"));
        }
        super(attributeName, parent);
        this.myDefaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getStringValue() {
        return Boolean.toString(this.getValue());
    }

    @Override
    @NotNull
    public Boolean getValue() {
        Boolean value = JamCommonUtil.getObjectValue(this.getPsiElement(), Boolean.class);
        Boolean bl = value != null ? value : this.myDefaultValue;
        if (bl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jam/JamBooleanAttributeElement", "getValue"));
        }
        return bl;
    }
}

