/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PausesStat;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionUtil {
    @NonNls
    private static final String WAS_ENABLED_BEFORE_DUMB = "WAS_ENABLED_BEFORE_DUMB";
    @NonNls
    public static final String WOULD_BE_ENABLED_IF_NOT_DUMB_MODE = "WOULD_BE_ENABLED_IF_NOT_DUMB_MODE";
    @NonNls
    private static final String WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE = "WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE";
    private static int insidePerformDumbAwareUpdate;

    private ActionUtil() {
    }

    public static void showDumbModeWarning(AnActionEvent ... events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/actionSystem/ex/ActionUtil", "showDumbModeWarning"));
        }
        Project project = null;
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : events) {
            Project _project;
            String s = event.getPresentation().getText();
            if (StringUtil.isNotEmpty((String)s)) {
                actionNames.add(s);
            }
            if ((_project = event.getProject()) == null || project != null) continue;
            project = _project;
        }
        if (project == null) {
            return;
        }
        DumbService.getInstance(project).showDumbModeNotification(ActionUtil.getActionUnavailableMessage(actionNames));
    }

    @NotNull
    private static String getActionUnavailableMessage(@NotNull List<String> actionNames) {
        if (actionNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionNames", "com/intellij/openapi/actionSystem/ex/ActionUtil", "getActionUnavailableMessage"));
        }
        String beAvailableUntil = " available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
        String message = actionNames.isEmpty() ? "This action is not" + beAvailableUntil : (actionNames.size() == 1 ? "'" + actionNames.get(0) + "' action is not" + beAvailableUntil : "None of the following actions are" + beAvailableUntil + ": " + StringUtil.join(actionNames, (String)", "));
        String string = message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ActionUtil", "getActionUnavailableMessage"));
        }
        return string;
    }

    @NotNull
    public static String getUnavailableMessage(@NotNull String action, boolean plural) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ex/ActionUtil", "getUnavailableMessage"));
        }
        String string = action + (plural ? " are" : " is") + " not available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ActionUtil", "getUnavailableMessage"));
        }
        return string;
    }

    public static boolean performDumbAwareUpdate(boolean isInModalContext, @NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        boolean notAllowed;
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ex/ActionUtil", "performDumbAwareUpdate"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ex/ActionUtil", "performDumbAwareUpdate"));
        }
        Presentation presentation = e.getPresentation();
        Boolean wasEnabledBefore = (Boolean)presentation.getClientProperty(WAS_ENABLED_BEFORE_DUMB);
        boolean dumbMode = ActionUtil.isDumbMode(e.getProject());
        if (wasEnabledBefore != null && !dumbMode) {
            presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, null);
            presentation.setEnabled(wasEnabledBefore);
            presentation.setVisible(true);
        }
        boolean enabledBeforeUpdate = presentation.isEnabled();
        boolean bl = notAllowed = dumbMode && !action.isDumbAware() || Registry.is((String)"actionSystem.honor.modal.context") && isInModalContext && !action.isEnabledInModalContext();
        if (insidePerformDumbAwareUpdate++ == 0) {
            ActionPauses.STAT.started();
        }
        try {
            if (beforeActionPerformed) {
                action.beforeActionPerformedUpdate(e);
            } else {
                action.update(e);
            }
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, notAllowed && presentation.isEnabled());
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, notAllowed && presentation.isVisible());
        }
        catch (IndexNotReadyException e1) {
            if (notAllowed) {
                boolean bl2 = true;
                return bl2;
            }
            throw e1;
        }
        finally {
            if (--insidePerformDumbAwareUpdate == 0) {
                ActionPauses.STAT.finished(presentation.getText() + " action update (" + action.getClass() + ")");
            }
            if (notAllowed) {
                if (wasEnabledBefore == null) {
                    presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, enabledBeforeUpdate);
                }
                presentation.setEnabled(false);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean performDumbAwareUpdate(@NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ex/ActionUtil", "performDumbAwareUpdate"));
        }
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/actionSystem/ex/ActionUtil", "performDumbAwareUpdate"));
        }
        return ActionUtil.performDumbAwareUpdate(false, action, e, beforeActionPerformed);
    }

    public static boolean isDumbMode(@Nullable Project project) {
        if (project != null) {
            return DumbService.getInstance(project).isDumb();
        }
        for (Project proj : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbService.getInstance(proj).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static boolean lastUpdateAndCheckDumb(AnAction action, AnActionEvent e, boolean visibilityMatters) {
        ActionUtil.performDumbAwareUpdate(false, action, e, true);
        Project project = e.getProject();
        if (project != null && DumbService.getInstance(project).isDumb() && !action.isDumbAware()) {
            if (Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                return false;
            }
            if (visibilityMatters && Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE))) {
                return false;
            }
            ActionUtil.showDumbModeWarning(e);
            return false;
        }
        if (!e.getPresentation().isEnabled()) {
            return false;
        }
        return !visibilityMatters || e.getPresentation().isVisible();
    }

    public static void performActionDumbAware(final AnAction action, final AnActionEvent e) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    action.actionPerformed(e);
                }
                catch (IndexNotReadyException e1) {
                    ActionUtil.showDumbModeWarning(e);
                }
            }

            public String toString() {
                return action + " of " + action.getClass();
            }
        };
        if (action.startInTransaction()) {
            TransactionGuard.getInstance().submitTransactionAndWait(runnable);
        } else {
            runnable.run();
        }
    }

    @NotNull
    public static List<AnAction> getActions(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/ex/ActionUtil", "getActions"));
        }
        List list = ContainerUtil.notNullize((List)((List)UIUtil.getClientProperty((Object)component, AnAction.ACTIONS_KEY)));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/ex/ActionUtil", "getActions"));
        }
        return list;
    }

    public static void clearActions(@NotNull JComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/ex/ActionUtil", "clearActions"));
        }
        UIUtil.putClientProperty((JComponent)component, AnAction.ACTIONS_KEY, null);
    }

    public static void copyRegisteredShortcuts(@NotNull JComponent to, @NotNull JComponent from) {
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/openapi/actionSystem/ex/ActionUtil", "copyRegisteredShortcuts"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/openapi/actionSystem/ex/ActionUtil", "copyRegisteredShortcuts"));
        }
        for (AnAction anAction : ActionUtil.getActions(from)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), to);
        }
    }

    public static void registerForEveryKeyboardShortcut(@NotNull JComponent component, @NotNull ActionListener action, @NotNull ShortcutSet shortcuts) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/ex/ActionUtil", "registerForEveryKeyboardShortcut"));
        }
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ex/ActionUtil", "registerForEveryKeyboardShortcut"));
        }
        if (shortcuts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shortcuts", "com/intellij/openapi/actionSystem/ex/ActionUtil", "registerForEveryKeyboardShortcut"));
        }
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            component.registerKeyboardAction(action, first, 2);
        }
    }

    public static void recursiveRegisterShortcutSet(@NotNull ActionGroup group, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/actionSystem/ex/ActionUtil", "recursiveRegisterShortcutSet"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/actionSystem/ex/ActionUtil", "recursiveRegisterShortcutSet"));
        }
        for (AnAction action : group.getChildren(null)) {
            if (action instanceof ActionGroup) {
                ActionUtil.recursiveRegisterShortcutSet((ActionGroup)action, component, parentDisposable);
            }
            action.registerCustomShortcutSet(component, parentDisposable);
        }
    }

    public static AnAction copyFrom(@NotNull AnAction action, @NotNull String actionId) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ex/ActionUtil", "copyFrom"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/ex/ActionUtil", "copyFrom"));
        }
        action.copyFrom(ActionManager.getInstance().getAction(actionId));
        return action;
    }

    public static AnAction mergeFrom(@NotNull AnAction action, @NotNull String actionId) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/ex/ActionUtil", "mergeFrom"));
        }
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/openapi/actionSystem/ex/ActionUtil", "mergeFrom"));
        }
        AnAction a1 = action;
        AnAction a2 = ActionManager.getInstance().getAction(actionId);
        Presentation p1 = a1.getTemplatePresentation();
        Presentation p2 = a2.getTemplatePresentation();
        p1.setIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getIcon(), (Object)p2.getIcon()));
        p1.setDisabledIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getDisabledIcon(), (Object)p2.getDisabledIcon()));
        p1.setSelectedIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getSelectedIcon(), (Object)p2.getSelectedIcon()));
        p1.setHoveredIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getHoveredIcon(), (Object)p2.getHoveredIcon()));
        if (StringUtil.isEmpty((String)p1.getText())) {
            p1.setText(p2.getTextWithMnemonic(), p2.getDisplayedMnemonicIndex() >= 0);
        }
        p1.setDescription((String)ObjectUtils.chooseNotNull((Object)p1.getDescription(), (Object)p2.getDescription()));
        ShortcutSet ss1 = a1.getShortcutSet();
        if (ss1 == null || ss1 == CustomShortcutSet.EMPTY) {
            a1.copyShortcutFrom(a2);
        }
        return a1;
    }

    public static class ActionPauses {
        public static final PausesStat STAT = new PausesStat("AnAction.update()");
    }
}

