/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.ex;

import com.intellij.ide.util.JavaAnonymousClassesHelper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerPathsEx
extends CompilerPaths {
    public static void visitFiles(Collection<VirtualFile> directories, FileVisitor visitor) {
        for (VirtualFile outputDir : directories) {
            ApplicationManager.getApplication().runReadAction(() -> {
                String path2 = outputDir.getPath();
                visitor.accept(outputDir, path2, path2);
            });
        }
    }

    public static String[] getOutputPaths(Module[] modules) {
        OrderedSet outputPaths = new OrderedSet();
        for (Module module : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension;
            CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension = !module.isDisposed() ? CompilerModuleExtension.getInstance(module) : null;
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) != null) {
                outputPaths.add(VirtualFileManager.extractPath(outputPathForTestsUrl).replace('/', File.separatorChar));
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
                if (!handlerFactory.isApplicable(module)) continue;
                OrderEnumerationHandler handler = handlerFactory.createHandler(module);
                SmartList outputUrls = new SmartList();
                handler.addCustomModuleRoots(OrderRootType.CLASSES, moduleRootManager, (Collection<String>)outputUrls, true, true);
                for (String outputUrl : outputUrls) {
                    outputPaths.add(VirtualFileManager.extractPath(outputUrl).replace('/', File.separatorChar));
                }
            }
        }
        return ArrayUtil.toStringArray((Collection)outputPaths);
    }

    @Nullable
    public static ClassFileDescriptor findClassFileInOutput(@NotNull PsiClass sourceClass) {
        if (sourceClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceClass", "com/intellij/openapi/compiler/ex/CompilerPathsEx", "findClassFileInOutput"));
        }
        String classVMName = CompilerPathsEx.getClassVMName(sourceClass);
        if (classVMName == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement(sourceClass);
        if (module == null) {
            PsiClass aClass;
            Project project = sourceClass.getProject();
            PsiClass topLevelClass = PsiUtil.getTopLevelClass(sourceClass);
            String qualifiedName = topLevelClass != null ? topLevelClass.getQualifiedName() : null;
            PsiClass psiClass = aClass = qualifiedName != null ? JavaPsiFacade.getInstance(project).findClass(qualifiedName, sourceClass.getResolveScope()) : null;
            if (aClass != null) {
                final VirtualFile virtualFile = PsiUtilCore.getVirtualFile(aClass);
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
                if (virtualFile != null && fileIndex.isInLibraryClasses(virtualFile)) {
                    return new ClassFileDescriptor(){

                        @Override
                        public byte[] loadFileBytes() throws IOException {
                            return virtualFile.contentsToByteArray();
                        }

                        @Override
                        public String getPath() {
                            return virtualFile.getPath();
                        }
                    };
                }
            }
            return null;
        }
        PsiFile containingFile = sourceClass.getContainingFile();
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        CompilerModuleExtension moduleExtension = CompilerModuleExtension.getInstance(module);
        if (moduleExtension == null) {
            return null;
        }
        VirtualFile classRoot = ProjectRootManager.getInstance(module.getProject()).getFileIndex().isInTestSourceContent(virtualFile) ? moduleExtension.getCompilerOutputPathForTests() : moduleExtension.getCompilerOutputPath();
        if (classRoot == null) {
            return null;
        }
        String classFilePath = classRoot.getPath() + "/" + classVMName.replace('.', '/') + ".class";
        final File classFile = new File(classFilePath);
        if (!classFile.exists()) {
            return null;
        }
        return new ClassFileDescriptor(){

            @Override
            public byte[] loadFileBytes() throws IOException {
                return FileUtil.loadFileBytes((File)classFile);
            }

            @Override
            public String getPath() {
                return FileUtil.toSystemIndependentName((String)classFile.getPath());
            }
        };
    }

    @Nullable
    private static String getClassVMName(PsiClass containingClass) {
        if (containingClass instanceof PsiAnonymousClass) {
            PsiClass containingClassOfAnonymous = PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class);
            if (containingClassOfAnonymous == null) {
                return null;
            }
            return CompilerPathsEx.getClassVMName(containingClassOfAnonymous) + JavaAnonymousClassesHelper.getName((PsiAnonymousClass)containingClass);
        }
        return ClassUtil.getJVMClassName(containingClass);
    }

    public static interface ClassFileDescriptor {
        public byte[] loadFileBytes() throws IOException;

        public String getPath();
    }

    public static class FileVisitor {
        protected void accept(VirtualFile file, String fileRoot, String filePath2) {
            if (file.isDirectory()) {
                this.acceptDirectory(file, fileRoot, filePath2);
            } else {
                this.acceptFile(file, fileRoot, filePath2);
            }
        }

        protected void acceptFile(VirtualFile file, String fileRoot, String filePath2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void acceptDirectory(VirtualFile file, String fileRoot, String filePath2) {
            VirtualFile[] children;
            ProgressManager.checkCanceled();
            for (VirtualFile child : children = file.getChildren()) {
                String _filePath;
                String name = child.getName();
                StringBuilder buf = StringBuilderSpinAllocator.alloc();
                try {
                    buf.append(filePath2).append("/").append(name);
                    _filePath = buf.toString();
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)buf);
                }
                this.accept(child, fileRoot, _filePath);
            }
        }
    }
}

