/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.im.InputContext;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeyboardSettings", storages={@Storage(value="keyboard.xml")})
public class KeyboardSettingsExternalizable
implements PersistentStateComponent<OptionSet> {
    private static final String[] supportedNonEnglishLanguages = new String[]{"de", "fr", "it", "uk"};
    private OptionSet myOptions = new OptionSet();

    public static boolean isSupportedKeyboardLayout(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeyboardSettingsExternalizable", "isSupportedKeyboardLayout"));
        }
        if (Registry.is((String)"ide.keyboard.dvorak")) {
            return true;
        }
        if (SystemInfo.isMac) {
            return false;
        }
        String keyboardLayoutLanguage = KeyboardSettingsExternalizable.getLanguageForComponent(component);
        for (String language : supportedNonEnglishLanguages) {
            if (!language.equals(keyboardLayoutLanguage)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getLanguageForComponent(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeyboardSettingsExternalizable", "getLanguageForComponent"));
        }
        Locale locale = KeyboardSettingsExternalizable.getLocaleForComponent(component);
        return locale == null ? null : locale.getLanguage();
    }

    @Nullable
    protected static Locale getLocaleForComponent(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeyboardSettingsExternalizable", "getLocaleForComponent"));
        }
        InputContext context = component.getInputContext();
        return context == null ? null : context.getLocale();
    }

    @Nullable
    public static String getDisplayLanguageNameForComponent(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeyboardSettingsExternalizable", "getDisplayLanguageNameForComponent"));
        }
        Locale locale = KeyboardSettingsExternalizable.getLocaleForComponent(component);
        return locale == null ? null : locale.getDisplayLanguage();
    }

    public static KeyboardSettingsExternalizable getInstance() {
        if (ApplicationManager.getApplication().isDisposed()) {
            return new KeyboardSettingsExternalizable();
        }
        return ServiceManager.getService(KeyboardSettingsExternalizable.class);
    }

    @Override
    @Nullable
    public OptionSet getState() {
        return this.myOptions;
    }

    @Override
    public void loadState(OptionSet state) {
        this.myOptions = state;
    }

    public boolean isUkrainianKeyboard(Component c) {
        return c != null && "uk".equals(c.getInputContext().getLocale().getLanguage());
    }

    public boolean isNonEnglishKeyboardSupportEnabled() {
        return this.myOptions.USE_NON_ENGLISH_KEYBOARD;
    }

    public void setNonEnglishKeyboardSupportEnabled(boolean enabled) {
        this.myOptions.USE_NON_ENGLISH_KEYBOARD = enabled;
    }

    public static final class OptionSet {
        public boolean USE_NON_ENGLISH_KEYBOARD = false;
    }
}

