/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

@Tag(value="configurable")
public class ConfigurableEP<T extends UnnamedConfigurable>
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.options.ConfigurableEP");
    @Attribute(value="displayName")
    public String displayName;
    @Attribute(value="key")
    public String key;
    @Attribute(value="bundle")
    public String bundle;
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false)
    public ConfigurableEP[] children;
    @Attribute(value="childrenEPName")
    public String childrenEPName;
    @Attribute(value="dynamic")
    public boolean dynamic;
    @Attribute(value="parentId")
    public String parentId;
    @Attribute(value="id")
    public String id;
    @Attribute(value="groupId")
    public String groupId;
    @Attribute(value="groupWeight")
    public int groupWeight;
    @Attribute(value="nonDefaultProject")
    public boolean nonDefaultProject;
    @Deprecated
    @Attribute(value="implementation")
    public String implementationClass;
    @Attribute(value="instance")
    public String instanceClass;
    @Attribute(value="provider")
    public String providerClass;
    private final AtomicNotNullLazyValue<ObjectProducer> myProducer;
    private PicoContainer myPicoContainer;
    private Project myProject;

    public String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        LOG.assertTrue(this.bundle != null, (Object)("Bundle missed for " + this.instanceClass));
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)this.bundle, (ClassLoader)this.myPluginDescriptor.getPluginClassLoader());
        this.displayName = CommonBundle.message((ResourceBundle)resourceBundle, (String)this.key, (Object[])new Object[0]);
        return this.displayName;
    }

    public ResourceBundle findBundle() {
        return this.bundle == null ? null : AbstractBundle.getResourceBundle((String)this.bundle, (ClassLoader)(this.myPluginDescriptor != null ? this.myPluginDescriptor.getPluginClassLoader() : ((Object)((Object)this)).getClass().getClassLoader()));
    }

    public ConfigurableEP[] getChildren() {
        for (ConfigurableEP child : this.children) {
            child.myPicoContainer = this.myPicoContainer;
            child.myPluginDescriptor = this.myPluginDescriptor;
            child.myProject = this.myProject;
        }
        return this.children;
    }

    public boolean isAvailable() {
        return !this.nonDefaultProject || this.myProject == null || !this.myProject.isDefault();
    }

    public ConfigurableEP() {
        this(ApplicationManager.getApplication().getPicoContainer(), null);
    }

    public ConfigurableEP(Project project) {
        this(project.getPicoContainer(), project);
    }

    protected ConfigurableEP(PicoContainer picoContainer, @Nullable Project project) {
        this.myProject = project;
        this.myPicoContainer = picoContainer;
        this.myProducer = new AtomicNotNullLazyValue<ObjectProducer>(){

            @NotNull
            protected ObjectProducer compute() {
                block12: {
                    ClassProducer classProducer;
                    block13: {
                        block10: {
                            ClassProducer classProducer2;
                            block11: {
                                block8: {
                                    ProviderProducer providerProducer;
                                    block9: {
                                        if (ConfigurableEP.this.providerClass == null) break block8;
                                        providerProducer = new ProviderProducer((ConfigurableProvider)ConfigurableEP.this.instantiate(ConfigurableEP.this.providerClass, ConfigurableEP.this.myPicoContainer));
                                        if (providerProducer != null) break block9;
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                                    }
                                    return providerProducer;
                                }
                                if (ConfigurableEP.this.instanceClass == null) break block10;
                                classProducer2 = new ClassProducer(ConfigurableEP.this.myPicoContainer, ConfigurableEP.this.findClass(ConfigurableEP.this.instanceClass));
                                if (classProducer2 != null) break block11;
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                            }
                            return classProducer2;
                        }
                        if (ConfigurableEP.this.implementationClass == null) break block12;
                        classProducer = new ClassProducer(ConfigurableEP.this.myPicoContainer, ConfigurableEP.this.findClass(ConfigurableEP.this.implementationClass));
                        if (classProducer != null) break block13;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                    }
                    return classProducer;
                }
                try {
                    throw new RuntimeException("configurable class name is not set");
                }
                catch (AssertionError error) {
                    LOG.error((Throwable)((Object)error));
                }
                catch (LinkageError error) {
                    LOG.error((Throwable)error);
                }
                catch (Exception exception) {
                    LOG.error((Throwable)exception);
                }
                ObjectProducer objectProducer = new ObjectProducer();
                if (objectProducer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ConfigurableEP$1", "compute"));
                }
                return objectProducer;
            }
        };
    }

    @Nullable
    public T createConfigurable() {
        ObjectProducer producer = (ObjectProducer)this.myProducer.getValue();
        if (producer.canCreateElement()) {
            UnnamedConfigurable configurable = (UnnamedConfigurable)producer.createElement();
            return (T)configurable;
        }
        return null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean canCreateConfigurable() {
        return ((ObjectProducer)this.myProducer.getValue()).canCreateElement();
    }

    @Nullable
    public Class<?> getConfigurableType() {
        return ((ObjectProducer)this.myProducer.getValue()).getType();
    }

    private static final class ClassProducer
    extends ObjectProducer {
        private final PicoContainer myContainer;
        private final Class<?> myType;

        private ClassProducer(PicoContainer container, Class<?> type) {
            this.myContainer = container;
            this.myType = type;
        }

        @Override
        Object createElement() {
            try {
                return AbstractExtensionPointBean.instantiate(this.myType, (PicoContainer)this.myContainer, (boolean)true);
            }
            catch (ProcessCanceledException exception) {
                throw exception;
            }
            catch (AssertionError | Exception | LinkageError e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        @Override
        boolean canCreateElement() {
            return this.myType != null;
        }

        @Override
        Class<?> getType() {
            return this.myType;
        }
    }

    private static final class ProviderProducer
    extends ObjectProducer {
        private final ConfigurableProvider myProvider;

        private ProviderProducer(ConfigurableProvider provider) {
            this.myProvider = provider;
        }

        @Override
        Object createElement() {
            return this.myProvider == null ? null : this.myProvider.createConfigurable();
        }

        @Override
        boolean canCreateElement() {
            return this.myProvider != null && this.myProvider.canCreateConfigurable();
        }
    }

    private static class ObjectProducer {
        private ObjectProducer() {
        }

        Object createElement() {
            return null;
        }

        boolean canCreateElement() {
            return false;
        }

        Class<?> getType() {
            return null;
        }
    }
}

