/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ComponentSettings;
import com.intellij.ui.components.Interpolator;
import com.intellij.ui.components.SmoothBoundedRangeModel;
import com.intellij.ui.components.TargetHolder;
import com.intellij.util.SystemProperties;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.reflect.Field;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;
import org.jetbrains.annotations.Nullable;

public class SmoothScrollPane
extends JScrollPane {
    private static final Logger LOG = Logger.getInstance(SmoothScrollPane.class);
    private static final double EPSILON = 1.0E-5;
    private static final int THUMB_DELAY = 50;
    private static final int WHEEL_MIN_DELAY = 60;
    private static final int WHEEL_MAX_DELAY = 140;
    private static final int DEFAULT_DELAY = 120;
    private InputSource myInputSource = InputSource.UNKNOWN;
    private double myWheelRotation;

    public SmoothScrollPane() {
    }

    public SmoothScrollPane(Component view) {
        super(view);
    }

    public SmoothScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
    }

    public SmoothScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e) {
        this.myInputSource = InputSource.MOUSE_WHEEL;
        this.myWheelRotation = e.getPreciseWheelRotation();
        super.processMouseWheelEvent(e);
        this.myInputSource = InputSource.UNKNOWN;
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new SmoothScrollBar(1);
    }

    @Override
    public JScrollBar createHorizontalScrollBar() {
        return new SmoothScrollBar(0);
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        if (ui instanceof BasicScrollPaneUI) {
            try {
                Field field = BasicScrollPaneUI.class.getDeclaredField("mouseScrollListener");
                field.setAccessible(true);
                Object value = field.get(ui);
                if (value instanceof MouseWheelListener) {
                    MouseWheelListener oldListener = (MouseWheelListener)value;
                    MouseWheelListener newListener = e -> this.handleMouseWheelEvent(e, oldListener);
                    field.set(ui, newListener);
                    this.removeMouseWheelListener(oldListener);
                    this.addMouseWheelListener(newListener);
                }
            }
            catch (Exception exception) {
                LOG.warn((Throwable)exception);
            }
        }
    }

    private void handleMouseWheelEvent(MouseWheelEvent e, MouseWheelListener delegate) {
        if (ComponentSettings.getInstance().isSmoothScrollingEligibleFor(this) && this.isWheelScrollingEnabled() && e.getScrollType() == 0) {
            this.mouseWheelMoved(e);
            e.consume();
        } else {
            delegate.mouseWheelMoved(e);
        }
    }

    private void mouseWheelMoved(MouseWheelEvent e) {
        JScrollBar scrollbar = e.isShiftDown() ? this.getHorizontalScrollBar() : this.getVerticalScrollBar();
        JViewport viewport = this.getViewport();
        double rotation = e.getPreciseWheelRotation();
        int direction = rotation < 0.0 ? -1 : 1;
        int unitIncrement = SmoothScrollPane.getUnitIncrement(viewport, scrollbar, direction);
        double delta = rotation * (double)e.getScrollAmount() * (double)unitIncrement;
        boolean limitDelta = Math.abs(rotation) < 1.00001;
        int blockIncrement = SmoothScrollPane.getBlockIncrement(viewport, scrollbar, direction);
        double adjustedDelta = limitDelta ? Math.max(-((double)blockIncrement), Math.min(delta, (double)blockIncrement)) : delta;
        int value = scrollbar instanceof TargetHolder ? ((TargetHolder)((Object)scrollbar)).getTarget() : scrollbar.getValue();
        int newValue = Math.max(scrollbar.getMinimum(), Math.min((int)Math.round((double)value + adjustedDelta), scrollbar.getMaximum()));
        if (newValue != value) {
            scrollbar.setValue(newValue);
        }
    }

    private static int getUnitIncrement(JViewport viewport, JScrollBar scrollbar, int direction) {
        Scrollable scrollable = SmoothScrollPane.getScrollable(viewport);
        if (scrollable == null) {
            return scrollbar.getUnitIncrement(direction);
        }
        Rectangle r = new Rectangle(new Point(0, 0), viewport.getViewSize());
        return scrollable.getScrollableUnitIncrement(r, scrollbar.getOrientation(), 1);
    }

    private static int getBlockIncrement(JViewport viewport, JScrollBar scrollbar, int direction) {
        Scrollable scrollable = SmoothScrollPane.getScrollable(viewport);
        Rectangle r = new Rectangle(new Point(0, 0), viewport.getViewSize());
        return scrollable == null ? scrollbar.getBlockIncrement(direction) : scrollable.getScrollableBlockIncrement(r, scrollbar.getOrientation(), 1);
    }

    @Nullable
    private static Scrollable getScrollable(JViewport viewport) {
        return viewport != null && viewport.getView() instanceof Scrollable ? (Scrollable)((Object)viewport.getView()) : null;
    }

    public int getInitialDelay(boolean valueIsAdjusting) {
        InputSource source = valueIsAdjusting ? InputSource.SCROLLBAR_THUMB : this.myInputSource;
        switch (source) {
            case SCROLLBAR_THUMB: {
                return 50;
            }
            case MOUSE_WHEEL: {
                return Math.max(60, Math.min((int)Math.round(Math.abs(this.myWheelRotation) * 140.0), 140));
            }
        }
        return 120;
    }

    protected class SmoothScrollBar
    extends JScrollPane.ScrollBar
    implements TargetHolder {
        private final Interpolator myInterpolator;

        protected SmoothScrollBar(int orientation) {
            super(SmoothScrollPane.this, orientation);
            this.myInterpolator = new Interpolator(() -> super.getValue(), x$0 -> super.setValue((int)x$0));
            if (SystemProperties.isTrueSmoothScrollingEnabled()) {
                this.setModel(new SmoothBoundedRangeModel(this));
            }
        }

        @Override
        public void setValue(int value) {
            if (ComponentSettings.getInstance().isSmoothScrollingEligibleFor(SmoothScrollPane.this.getViewport().getView())) {
                this.myInterpolator.setTarget(value, SmoothScrollPane.this.getInitialDelay(this.getValueIsAdjusting()));
            } else {
                super.setValue(value);
            }
        }

        @Override
        public int getTarget() {
            return this.myInterpolator.getTarget();
        }
    }

    private static enum InputSource {
        SCROLLBAR_THUMB,
        MOUSE_WHEEL,
        UNKNOWN;

    }
}

