/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.util.ui.UIUtil;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UsageViewTreeModelBuilder
extends DefaultTreeModel {
    private final RootGroupNode myRootNode;
    private final TargetsRootNode myTargetsNode;
    private final UsageTarget[] myTargets;
    private UsageTargetNode[] myTargetNodes;
    private final String myTargetsNodeText;

    public UsageViewTreeModelBuilder(@NotNull UsageViewPresentation presentation, @NotNull UsageTarget[] targets) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/usages/impl/UsageViewTreeModelBuilder", "<init>"));
        }
        if (targets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targets", "com/intellij/usages/impl/UsageViewTreeModelBuilder", "<init>"));
        }
        super(new RootGroupNode());
        this.myRootNode = (RootGroupNode)this.root;
        this.myTargetsNodeText = presentation.getTargetsNodeText();
        this.myTargets = targets;
        this.myTargetsNode = this.myTargetsNodeText == null ? null : new TargetsRootNode(this.myTargetsNodeText);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTargetsNodeText != null) {
                this.addTargetNodes();
            }
            this.setRoot(this.myRootNode);
        });
    }

    private void addTargetNodes() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myTargets.length == 0) {
            return;
        }
        this.myTargetNodes = new UsageTargetNode[this.myTargets.length];
        this.myTargetsNode.removeAllChildren();
        for (int i = 0; i < this.myTargets.length; ++i) {
            UsageTarget target = this.myTargets[i];
            UsageTargetNode targetNode = new UsageTargetNode(target);
            this.myTargetsNode.add(targetNode);
            this.myTargetNodes[i] = targetNode;
        }
        this.myRootNode.addTargetsNode(this.myTargetsNode, this);
        this.reload(this.myTargetsNode);
    }

    UsageNode getFirstUsageNode() {
        return (UsageNode)UsageViewTreeModelBuilder.getFirstChildOfType(this.myRootNode, UsageNode.class);
    }

    private static TreeNode getFirstChildOfType(TreeNode parent, Class type) {
        int childCount = parent.getChildCount();
        for (int idx = 0; idx < childCount; ++idx) {
            TreeNode child = parent.getChildAt(idx);
            if (type.isAssignableFrom(child.getClass())) {
                return child;
            }
            TreeNode firstChildOfType = UsageViewTreeModelBuilder.getFirstChildOfType(child, type);
            if (firstChildOfType == null) continue;
            return firstChildOfType;
        }
        return null;
    }

    boolean areTargetsValid() {
        if (this.myTargetNodes == null) {
            return true;
        }
        for (UsageTargetNode targetNode : this.myTargetNodes) {
            if (targetNode.isValid()) continue;
            return false;
        }
        return true;
    }

    void reset() {
        this.myRootNode.removeAllChildren();
        if (this.myTargetsNodeText != null && this.myTargets.length > 0) {
            this.addTargetNodes();
        }
        this.reload(this.myRootNode);
    }

    @Override
    public Object getRoot() {
        return this.myRootNode;
    }

    @Override
    public void nodeChanged(TreeNode node) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodeChanged(node);
    }

    @Override
    public void nodesWereInserted(TreeNode node, int[] childIndices) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodesWereInserted(node, childIndices);
    }

    @Override
    public void nodesWereRemoved(TreeNode node, int[] childIndices, Object[] removedChildren) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodesWereRemoved(node, childIndices, removedChildren);
    }

    @Override
    public void nodesChanged(TreeNode node, int[] childIndices) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodesChanged(node, childIndices);
    }

    @Override
    public void nodeStructureChanged(TreeNode node) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.nodeStructureChanged(node);
    }

    @Override
    protected void fireTreeNodesChanged(Object source, Object[] path2, int[] childIndices, Object[] children) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeNodesChanged(source, path2, childIndices, children);
    }

    @Override
    protected void fireTreeNodesInserted(Object source, Object[] path2, int[] childIndices, Object[] children) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeNodesInserted(source, path2, childIndices, children);
    }

    @Override
    protected void fireTreeNodesRemoved(Object source, Object[] path2, int[] childIndices, Object[] children) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeNodesRemoved(source, path2, childIndices, children);
    }

    @Override
    protected void fireTreeStructureChanged(Object source, Object[] path2, int[] childIndices, Object[] children) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.fireTreeStructureChanged(source, path2, childIndices, children);
    }

    private static class RootGroupNode
    extends GroupNode {
        private RootGroupNode() {
            super(null, null, 0);
        }

        @Override
        @NonNls
        public String toString() {
            return "Root " + super.toString();
        }
    }

    static class TargetsRootNode
    extends Node {
        private TargetsRootNode(String name) {
            this.setUserObject(name);
        }

        @Override
        public String tree2string(int indent, String lineSeparator) {
            return null;
        }

        @Override
        protected boolean isDataValid() {
            return true;
        }

        @Override
        protected boolean isDataReadOnly() {
            return true;
        }

        @Override
        protected boolean isDataExcluded() {
            return false;
        }

        @Override
        protected String getText(@NotNull UsageView view) {
            if (view == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/usages/impl/UsageViewTreeModelBuilder$TargetsRootNode", "getText"));
            }
            return this.getUserObject().toString();
        }
    }
}

